/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.namespace.CreateOption;

public class PnfsCreateUploadPath
extends PnfsMessage {
    private final int uid;
    private final int gid;
    private final int mode;
    private final Long size;
    private final AccessLatency accessLatency;
    private final RetentionPolicy retentionPolicy;
    private final String spaceToken;
    private final Set<CreateOption> options;
    private final String rootPath;
    private String uploadPath;

    public PnfsCreateUploadPath(Subject subject, FsPath path, FsPath rootPath, int uid, int gid, int mode, Long size, AccessLatency accessLatency, RetentionPolicy retentionPolicy, String spaceToken, Set<CreateOption> options) {
        this.uid = uid;
        this.gid = gid;
        this.mode = mode;
        this.size = size;
        this.accessLatency = accessLatency;
        this.retentionPolicy = retentionPolicy;
        this.spaceToken = spaceToken;
        this.options = options;
        this.rootPath = rootPath.toString();
        this.setSubject(subject);
        this.setPnfsPath(path.toString());
        this.setReplyRequired(true);
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public int getMode() {
        return this.mode;
    }

    public AccessLatency getAccessLatency() {
        return this.accessLatency;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public String getSpaceToken() {
        return this.spaceToken;
    }

    public Long getSize() {
        return this.size;
    }

    public Set<CreateOption> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public FsPath getPath() {
        return new FsPath(this.getPnfsPath());
    }

    public FsPath getRootPath() {
        return this.rootPath == null ? new FsPath() : new FsPath(this.rootPath);
    }

    public FsPath getUploadPath() {
        return this.uploadPath == null ? null : new FsPath(this.uploadPath);
    }

    public void setUploadPath(FsPath uploadPath) {
        this.uploadPath = uploadPath.toString();
    }
}

