/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.List;

public class PnfsGetCacheLocationsMessage
extends PnfsMessage {
    private List<String> _cacheLocations;
    private static final long serialVersionUID = 6603606352524630293L;

    public PnfsGetCacheLocationsMessage() {
        this.setReplyRequired(true);
    }

    public PnfsGetCacheLocationsMessage(PnfsId pnfsId) {
        super(pnfsId);
        this.setReplyRequired(true);
    }

    public List<String> getCacheLocations() {
        return this._cacheLocations;
    }

    public void setCacheLocations(List<String> cacheLocations) {
        this._cacheLocations = cacheLocations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPnfsId()).append(";locs=");
        if (this._cacheLocations != null) {
            for (String location : this._cacheLocations) {
                sb.append(location).append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean invalidates(Message message) {
        return false;
    }

    @Override
    public boolean fold(Message message) {
        if (message.getClass().equals(PnfsGetCacheLocationsMessage.class)) {
            PnfsId pnfsId = this.getPnfsId();
            String path = this.getPnfsPath();
            PnfsGetCacheLocationsMessage msg = (PnfsGetCacheLocationsMessage)message;
            if ((pnfsId == null || pnfsId.equals(msg.getPnfsId())) && (path == null || path.equals(msg.getPnfsPath())) && this.getSubject().equals(msg.getSubject())) {
                this.setPnfsId(msg.getPnfsId());
                this.setPnfsPath(msg.getPnfsPath());
                this.setCacheLocations(msg.getCacheLocations());
                return true;
            }
        }
        return false;
    }
}

