/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolAcceptFileMessage
extends PoolIoFileMessage {
    private static final long serialVersionUID = 7898737438685700742L;
    private final long _preallocated;

    public PoolAcceptFileMessage(String pool, ProtocolInfo protocolInfo, FileAttributes fileAttributes) {
        this(pool, protocolInfo, fileAttributes, fileAttributes.isDefined(FileAttribute.SIZE) ? fileAttributes.getSize() : 0L);
    }

    public PoolAcceptFileMessage(String pool, ProtocolInfo protocolInfo, FileAttributes fileAttributes, long preallocated) {
        super(pool, protocolInfo, fileAttributes);
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(EnumSet.of(FileAttribute.ACCESS_LATENCY, FileAttribute.RETENTION_POLICY)));
        this._preallocated = preallocated;
    }

    public long getPreallocated() {
        return this._preallocated;
    }
}

