/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.PoolFlushControlInfoMessage;
import java.util.StringTokenizer;

public class PoolFlushDoFlushMessage
extends PoolFlushControlInfoMessage {
    private static final long serialVersionUID = 2092239799703855551L;
    private String _hsmName;
    private String _storageClassName;
    private int _maxFlushCount;
    private long _flushId;
    private int _totalFlushed;
    private int _totalFailed;
    private boolean _finished;

    public PoolFlushDoFlushMessage(String poolName, String composedStorageClass) {
        super(poolName);
        StringTokenizer st = new StringTokenizer(composedStorageClass, "@");
        this._storageClassName = st.nextToken();
        this._hsmName = st.nextToken();
        this.setReplyRequired(true);
    }

    public PoolFlushDoFlushMessage(String poolName, String hsmName, String storageClassName) {
        super(poolName);
        this._hsmName = hsmName;
        this._storageClassName = storageClassName;
        this.setReplyRequired(true);
    }

    public String getHsmName() {
        return this._hsmName;
    }

    public String getStorageClassName() {
        return this._storageClassName;
    }

    public void setMaxFlushCount(int count) {
        this._maxFlushCount = count;
    }

    public int getMaxFlushCount() {
        return this._maxFlushCount;
    }

    public void setFlushId(long flushId) {
        this._flushId = flushId;
    }

    public long getFlushId() {
        return this._flushId;
    }

    public void setResult(int totalFlushed, int totalFailed) {
        this._totalFlushed = totalFlushed;
        this._totalFailed = totalFailed;
        this._finished = true;
    }

    public int totalFailed() {
        return this._totalFailed;
    }

    public int totalFlushed() {
        return this._totalFlushed;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(";SC=").append(this._storageClassName).append("@").append(this._hsmName).append(";MAX=").append(this._maxFlushCount).append(";id=").append(this._flushId);
        if (this._finished) {
            sb.append(";total=").append(this._totalFlushed).append(";failed=").append(this._totalFailed);
        }
        return sb.toString();
    }

    public boolean isFinished() {
        return this._finished;
    }
}

