/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolIoFileMessage
extends PoolMessage {
    private FileAttributes _fileAttributes;
    private ProtocolInfo _protocolInfo;
    private boolean _isPool2Pool;
    private String _ioQueueName;
    private int _moverId;
    private String _initiator = "<undefined>";
    private boolean _forceSourceMode;
    private String _pnfsPath;
    private String _transferPath;
    private static final long serialVersionUID = -6549886547049510754L;

    public PoolIoFileMessage(String pool, ProtocolInfo protocolInfo, FileAttributes fileAttributes) {
        super(pool);
        Preconditions.checkNotNull((Object)fileAttributes);
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(EnumSet.of(FileAttribute.STORAGEINFO, FileAttribute.PNFSID)));
        this._fileAttributes = fileAttributes;
        this._protocolInfo = protocolInfo;
    }

    public PoolIoFileMessage(String pool, PnfsId pnfsId, ProtocolInfo protocolInfo) {
        super(pool);
        this._protocolInfo = protocolInfo;
        this._fileAttributes = new FileAttributes();
        this._fileAttributes.setPnfsId(pnfsId);
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public boolean isPool2Pool() {
        return this._isPool2Pool;
    }

    public void setPool2Pool() {
        this._isPool2Pool = true;
    }

    public void setIoQueueName(String ioQueueName) {
        this._ioQueueName = ioQueueName;
    }

    public String getIoQueueName() {
        return this._ioQueueName;
    }

    public int getMoverId() {
        return this._moverId;
    }

    public void setMoverId(int moverId) {
        this._moverId = moverId;
    }

    public void setInitiator(String initiator) {
        this._initiator = initiator;
    }

    public String getInitiator() {
        return this._initiator;
    }

    public String getBillingPath() {
        return this._pnfsPath != null ? this._pnfsPath : null;
    }

    public void setBillingPath(String path) {
        this._pnfsPath = path;
    }

    public String getTransferPath() {
        return this._transferPath != null ? this._transferPath : this.getBillingPath();
    }

    public void setTransferPath(String path) {
        this._transferPath = path;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public void setForceSourceMode(boolean forceSourceMode) {
        this._forceSourceMode = forceSourceMode;
    }

    public boolean isForceSourceMode() {
        return this._forceSourceMode;
    }

    @Override
    public String getDiagnosticContext() {
        return super.getDiagnosticContext() + " " + this.getPnfsId();
    }
}

