/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import diskCacheV111.pools.PoolCostInfo;
import java.io.Serializable;

public class PoolManagerPoolInformation
implements Serializable {
    private static final long serialVersionUID = -279163439475487756L;
    private final String _name;
    private double _cpuCost;
    private final PoolCostInfo _poolCostInfo;
    public static final Function<PoolManagerPoolInformation, String> GET_NAME = new Function<PoolManagerPoolInformation, String>(){

        public String apply(PoolManagerPoolInformation info) {
            return info.getName();
        }
    };

    public PoolManagerPoolInformation(String name, PoolCostInfo poolCostInfo, double cpuCost) {
        this._name = name;
        this._poolCostInfo = (PoolCostInfo)Preconditions.checkNotNull((Object)poolCostInfo);
        this._cpuCost = cpuCost;
    }

    public String getName() {
        return this._name;
    }

    public double getCpuCost() {
        return this._cpuCost;
    }

    public PoolCostInfo getPoolCostInfo() {
        return this._poolCostInfo;
    }

    public String toString() {
        return String.format("[name=%s;cpu=%f;cost=%s]", this._name, this._cpuCost, this._poolCostInfo);
    }
}

