/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolManagerMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellAddressCore;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolMgrGetPoolMsg
extends PoolManagerMessage {
    private static final long serialVersionUID = 8907604668091102254L;
    private final FileAttributes _fileAttributes;
    private String _poolName;
    private CellAddressCore _poolAddress;

    public PoolMgrGetPoolMsg(FileAttributes fileAttributes) {
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(PoolMgrGetPoolMsg.getRequiredAttributes()), (Object)"Required attributes are missing.");
        this._fileAttributes = fileAttributes;
        this.setReplyRequired(true);
    }

    @Nonnull
    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        return this._fileAttributes.getStorageInfo();
    }

    @Nonnull
    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public String getPoolName() {
        return this._poolName;
    }

    public void setPoolName(String poolName) {
        this._poolName = poolName;
    }

    public void setPoolAddress(CellAddressCore poolAddress) {
        this._poolAddress = poolAddress;
    }

    public CellAddressCore getPoolAddress() {
        return this._poolAddress;
    }

    @Override
    public String toString() {
        if (this.getReturnCode() == 0) {
            return "PnfsId=" + this.getPnfsId() + ";StorageInfo=" + this.getStorageInfo() + (this._poolName == null ? "" : ";PoolName=" + this._poolName) + (this._poolAddress == null ? "" : "PoolAddress=" + this._poolAddress);
        }
        return super.toString();
    }

    public static EnumSet<FileAttribute> getRequiredAttributes() {
        return EnumSet.of(FileAttribute.PNFSID, FileAttribute.STORAGEINFO, FileAttribute.STORAGECLASS, FileAttribute.HSM);
    }

    @Override
    public String getDiagnosticContext() {
        return super.getDiagnosticContext() + " " + this.getPnfsId();
    }
}

