/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import diskCacheV111.vehicles.IpProtocolInfo;
import java.net.InetSocketAddress;
import java.net.URI;

public class RemoteHttpDataTransferProtocolInfo
implements IpProtocolInfo {
    private final String name;
    private final int minor;
    private final int major;
    private final InetSocketAddress addr;
    private final int bufferSize;
    private final String sourceHttpUrl;
    private final boolean isVerificationRequired;
    private final ImmutableMap<String, String> headers;
    private static final long serialVersionUID = 4482469147378465931L;

    public RemoteHttpDataTransferProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, int buf_size, String url, boolean isVerificationRequired, ImmutableMap<String, String> headers) {
        this.name = protocol;
        this.minor = minor;
        this.major = major;
        this.addr = addr;
        this.sourceHttpUrl = url;
        this.bufferSize = buf_size;
        this.isVerificationRequired = isVerificationRequired;
        this.headers = (ImmutableMap)Preconditions.checkNotNull(headers);
    }

    public URI getUri() {
        return URI.create(this.sourceHttpUrl);
    }

    @Override
    public String getProtocol() {
        return this.name;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public String getVersionString() {
        return this.name + "-" + this.major + "." + this.minor;
    }

    public boolean isVerificationRequired() {
        return this.isVerificationRequired;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return this.getVersionString() + ':' + this.sourceHttpUrl;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }
}

