/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import diskCacheV111.vehicles.StorageInfo;
import java.util.Map;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;

public class StorageInfos {
    private StorageInfos() {
    }

    public static StorageInfo extractFrom(FileAttributes attributes) {
        StorageInfo info = attributes.getStorageInfo();
        if (attributes.isDefined(FileAttribute.SIZE)) {
            info.setLegacySize(attributes.getSize());
        }
        if (attributes.isDefined(FileAttribute.ACCESS_LATENCY)) {
            info.setLegacyAccessLatency(attributes.getAccessLatency());
        }
        if (attributes.isDefined(FileAttribute.RETENTION_POLICY)) {
            info.setLegacyRetentionPolicy(attributes.getRetentionPolicy());
        }
        if (attributes.isDefined(FileAttribute.FLAGS)) {
            for (Map.Entry<String, String> entry : attributes.getFlags().entrySet()) {
                info.setKey(entry.getKey(), entry.getValue());
            }
        }
        if (attributes.isDefined(FileAttribute.CHECKSUM)) {
            info.setKey("flag-c", Joiner.on((char)',').join(attributes.getChecksums()));
        }
        if (attributes.isDefined(FileAttribute.OWNER)) {
            info.setKey("uid", Integer.toString(attributes.getOwner()));
        }
        if (attributes.isDefined(FileAttribute.OWNER_GROUP)) {
            info.setKey("gid", Integer.toString(attributes.getGroup()));
        }
        if (attributes.isDefined(FileAttribute.STORAGECLASS)) {
            info.setStorageClass(attributes.getStorageClass());
        }
        if (attributes.isDefined(FileAttribute.CACHECLASS)) {
            info.setCacheClass(attributes.getCacheClass());
        }
        if (attributes.isDefined(FileAttribute.HSM)) {
            info.setHsm(attributes.getHsm());
        }
        return info;
    }

    public static FileAttributes injectInto(StorageInfo info, FileAttributes attributes) {
        String gid;
        String uid;
        attributes.setStorageInfo(info);
        attributes.setSize(info.getLegacySize());
        attributes.setAccessLatency(info.getLegacyAccessLatency());
        attributes.setRetentionPolicy(info.getLegacyRetentionPolicy());
        attributes.setStorageClass(info.getStorageClass());
        attributes.setCacheClass(info.getCacheClass());
        attributes.setHsm(info.getHsm());
        String cFlag = info.getKey("flag-c");
        if (cFlag != null) {
            attributes.setChecksums(Sets.newHashSet((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)cFlag), Checksum::parseChecksum)));
        }
        if ((uid = info.getKey("uid")) != null) {
            attributes.setOwner(Integer.parseInt(uid));
        }
        if ((gid = info.getKey("gid")) != null) {
            attributes.setGroup(Integer.parseInt(gid));
        }
        attributes.setFlags(info.getMap());
        return attributes;
    }
}

