/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.dcache.acl.ACL;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.Checksum;

public class FileAttributes
implements Serializable {
    private static final long serialVersionUID = -3689129805631724432L;
    private Set<FileAttribute> _definedAttributes = EnumSet.noneOf(FileAttribute.class);
    private ACL _acl;
    private long _size;
    private long _ctime;
    private long _creationTime;
    private long _atime;
    private long _mtime;
    private Set<Checksum> _checksums;
    private int _owner;
    private int _group;
    private int _mode;
    private AccessLatency _accessLatency;
    private RetentionPolicy _retentionPolicy;
    private FileType _fileType;
    private Collection<String> _locations;
    private Map<String, String> _flags;
    private PnfsId _pnfsId;
    private StorageInfo _storageInfo;
    private String _storageClass;
    private String _hsm;
    private String _cacheClass;

    private void guard(FileAttribute attribute) throws IllegalStateException {
        if (!this._definedAttributes.contains((Object)attribute)) {
            throw new IllegalStateException("Attribute is not defined: " + (Object)((Object)attribute));
        }
    }

    private void define(FileAttribute attribute) {
        this._definedAttributes.add(attribute);
    }

    public boolean isUndefined(FileAttribute attribute) {
        return !this._definedAttributes.contains((Object)attribute);
    }

    public boolean isDefined(FileAttribute attribute) {
        return this._definedAttributes.contains((Object)attribute);
    }

    public boolean isDefined(Set<FileAttribute> attributes) {
        return this._definedAttributes.containsAll(attributes);
    }

    @Nonnull
    public Set<FileAttribute> getDefinedAttributes() {
        return this._definedAttributes;
    }

    @Nonnull
    public AccessLatency getAccessLatency() {
        this.guard(FileAttribute.ACCESS_LATENCY);
        return this._accessLatency;
    }

    @Nonnull
    public Optional<AccessLatency> getAccessLatencyIfPresent() {
        return this.toOptional(FileAttribute.ACCESS_LATENCY, this._accessLatency);
    }

    public long getAccessTime() {
        this.guard(FileAttribute.ACCESS_TIME);
        return this._atime;
    }

    @Nonnull
    public ACL getAcl() {
        this.guard(FileAttribute.ACL);
        return this._acl;
    }

    @Nonnull
    public Set<Checksum> getChecksums() {
        this.guard(FileAttribute.CHECKSUM);
        return this._checksums;
    }

    @Nonnull
    public Optional<Set<Checksum>> getChecksumsIfPresent() {
        return this.toOptional(FileAttribute.CHECKSUM, this._checksums);
    }

    @Nonnull
    public FileType getFileType() {
        this.guard(FileAttribute.TYPE);
        return this._fileType;
    }

    public int getGroup() {
        this.guard(FileAttribute.OWNER_GROUP);
        return this._group;
    }

    public int getMode() {
        this.guard(FileAttribute.MODE);
        return this._mode;
    }

    public long getChangeTime() {
        this.guard(FileAttribute.CHANGE_TIME);
        return this._ctime;
    }

    public long getCreationTime() {
        this.guard(FileAttribute.CREATION_TIME);
        return this._creationTime;
    }

    public long getModificationTime() {
        this.guard(FileAttribute.MODIFICATION_TIME);
        return this._mtime;
    }

    public int getOwner() {
        this.guard(FileAttribute.OWNER);
        return this._owner;
    }

    @Nonnull
    public RetentionPolicy getRetentionPolicy() {
        this.guard(FileAttribute.RETENTION_POLICY);
        return this._retentionPolicy;
    }

    @Nonnull
    public Optional<RetentionPolicy> getRetentionPolicyIfPresent() {
        return this.toOptional(FileAttribute.RETENTION_POLICY, this._retentionPolicy);
    }

    public long getSize() {
        this.guard(FileAttribute.SIZE);
        return this._size;
    }

    public Optional<Long> getSizeIfPresent() {
        return this.toOptional(FileAttribute.SIZE, this._size);
    }

    @Nonnull
    public PnfsId getPnfsId() {
        this.guard(FileAttribute.PNFSID);
        return this._pnfsId;
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        this.guard(FileAttribute.STORAGEINFO);
        return this._storageInfo;
    }

    public void setAccessTime(long atime) {
        this.define(FileAttribute.ACCESS_TIME);
        this._atime = atime;
    }

    public void setAccessLatency(AccessLatency accessLatency) {
        this.define(FileAttribute.ACCESS_LATENCY);
        this._accessLatency = accessLatency;
    }

    public void setAcl(ACL acl) {
        this.define(FileAttribute.ACL);
        this._acl = acl;
    }

    public void setChecksums(Set<Checksum> checksums) {
        this.define(FileAttribute.CHECKSUM);
        this._checksums = checksums;
    }

    public void setFileType(FileType fileType) {
        this.define(FileAttribute.TYPE);
        this._fileType = fileType;
    }

    public void setGroup(int group) {
        this.define(FileAttribute.OWNER_GROUP);
        this._group = group;
    }

    public void setMode(int mode) {
        this.define(FileAttribute.MODE);
        this._mode = mode;
    }

    public void setChangeTime(long ctime) {
        this.define(FileAttribute.CHANGE_TIME);
        this._ctime = ctime;
    }

    public void setCreationTime(long creationTime) {
        this.define(FileAttribute.CREATION_TIME);
        this._creationTime = creationTime;
    }

    public void setModificationTime(long mtime) {
        this.define(FileAttribute.MODIFICATION_TIME);
        this._mtime = mtime;
    }

    public void setOwner(int owner) {
        this.define(FileAttribute.OWNER);
        this._owner = owner;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.define(FileAttribute.RETENTION_POLICY);
        this._retentionPolicy = retentionPolicy;
    }

    public void setSize(long size) {
        this.define(FileAttribute.SIZE);
        this._size = size;
    }

    public void setLocations(Collection<String> pools) {
        this.define(FileAttribute.LOCATIONS);
        this._locations = pools;
    }

    @Nonnull
    public Collection<String> getLocations() {
        this.guard(FileAttribute.LOCATIONS);
        return this._locations;
    }

    @Nonnull
    public Map<String, String> getFlags() {
        this.guard(FileAttribute.FLAGS);
        return this._flags;
    }

    public void setFlags(Map<String, String> flags) {
        this.define(FileAttribute.FLAGS);
        this._flags = flags;
    }

    public void setPnfsId(PnfsId pnfsId) {
        this.define(FileAttribute.PNFSID);
        this._pnfsId = pnfsId;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this.define(FileAttribute.STORAGEINFO);
        this._storageInfo = storageInfo;
    }

    public String getStorageClass() {
        this.guard(FileAttribute.STORAGECLASS);
        return this._storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.define(FileAttribute.STORAGECLASS);
        this._storageClass = storageClass;
    }

    public void setCacheClass(String cacheClass) {
        this.define(FileAttribute.CACHECLASS);
        this._cacheClass = Strings.nullToEmpty((String)cacheClass);
    }

    public String getCacheClass() {
        this.guard(FileAttribute.CACHECLASS);
        return Strings.emptyToNull((String)this._cacheClass);
    }

    public void setHsm(String hsm) {
        this.define(FileAttribute.HSM);
        this._hsm = hsm;
    }

    public String getHsm() {
        this.guard(FileAttribute.HSM);
        return this._hsm;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("defined", this._definedAttributes).add("acl", (Object)this._acl).add("size", this._size).add("ctime", this._ctime).add("creationTime", this._creationTime).add("atime", this._atime).add("mtime", this._mtime).add("checksums", this._checksums).add("owner", this._owner).add("group", this._group).add("mode", this._mode).add("accessLatency", (Object)this._accessLatency).add("retentionPolicy", (Object)this._retentionPolicy).add("fileType", (Object)this._fileType).add("locations", this._locations).add("flags", this._flags).add("pnfsId", (Object)this._pnfsId).add("storageInfo", (Object)this._storageInfo).add("storageClass", (Object)this._storageClass).add("cacheClass", (Object)this._cacheClass).add("hsm", (Object)this._hsm).omitNullValues().toString();
    }

    @Nonnull
    private <T> Optional<T> toOptional(FileAttribute attribute, T value) {
        return this.isDefined(attribute) ? Optional.of(value) : Optional.absent();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        boolean wasCacheClassDefined = this._definedAttributes.remove((Object)FileAttribute.CACHECLASS);
        stream.defaultWriteObject();
        if (wasCacheClassDefined) {
            this._definedAttributes.add(FileAttribute.CACHECLASS);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._flags != null) {
            this._flags = this._flags.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).intern(), e -> (String)e.getValue()));
        }
        if (this._storageClass != null) {
            this._storageClass = this._storageClass.intern();
        }
        if (this._cacheClass != null) {
            this._cacheClass = this._cacheClass.intern();
            this._definedAttributes.add(FileAttribute.CACHECLASS);
        }
        if (this._hsm != null) {
            this._hsm = this._hsm.intern();
        }
    }
}

