/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Glob;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.vehicles.FileAttributes;

public class PnfsListDirectoryMessage
extends PnfsMessage {
    private static final long serialVersionUID = -5774904472984157638L;
    private final Glob _pattern;
    private final Integer _lower;
    private final Integer _upper;
    private final BoundType _lowerBoundType;
    private final BoundType _upperBoundType;
    private final UUID _uuid = UUID.randomUUID();
    private final Set<FileAttribute> _requestedAttributes;
    private Collection<DirectoryEntry> _entries = new ArrayList<DirectoryEntry>();
    private boolean _isFinal;
    private int _messageCount;

    public PnfsListDirectoryMessage(String path, Glob pattern, Range<Integer> range, Set<FileAttribute> attr) {
        this.setPnfsPath((String)Preconditions.checkNotNull((Object)path));
        this.setReplyRequired(true);
        this._pattern = pattern;
        this._lower = range.hasLowerBound() ? (Integer)range.lowerEndpoint() : null;
        this._upper = range.hasUpperBound() ? (Integer)range.upperEndpoint() : null;
        this._lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : null;
        this._upperBoundType = range.hasUpperBound() ? range.upperBoundType() : null;
        this._requestedAttributes = attr;
    }

    public UUID getUUID() {
        return this._uuid;
    }

    public Glob getPattern() {
        return this._pattern;
    }

    public Range<Integer> getRange() {
        if (this._lower == null && this._upper == null) {
            return Range.all();
        }
        if (this._lower == null) {
            return Range.upTo((Comparable)this._upper, (BoundType)this._upperBoundType);
        }
        if (this._upper == null) {
            return Range.downTo((Comparable)this._lower, (BoundType)this._lowerBoundType);
        }
        return Range.range((Comparable)this._lower, (BoundType)this._lowerBoundType, (Comparable)this._upper, (BoundType)this._upperBoundType);
    }

    public Set<FileAttribute> getRequestedAttributes() {
        return this._requestedAttributes;
    }

    public void addEntry(String name, FileAttributes attr) {
        this._entries.add(new DirectoryEntry(name, attr));
    }

    public void setEntries(Collection<DirectoryEntry> entries) {
        this._entries = entries;
    }

    public Collection<DirectoryEntry> getEntries() {
        return this._entries;
    }

    public void clear() {
        this._entries.clear();
    }

    @Override
    public void setSucceeded() {
        super.setSucceeded();
        this._isFinal = true;
    }

    public void setSucceeded(int messageCount) {
        this.setSucceeded();
        this._messageCount = messageCount;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public int getMessageCount() {
        return this._messageCount;
    }

    @Override
    public boolean invalidates(Message message) {
        return false;
    }
}

