/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles.billing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.Message;
import java.io.Serializable;
import java.util.Arrays;

public abstract class AbstractBillingRequestMessage<T extends Serializable>
extends Message {
    private static final long serialVersionUID = 6844476040265685511L;
    private final String method;
    private final Class<? extends Serializable>[] parameterTypes;
    private final Serializable[] parameters;
    private final Class<T> returnType;
    private T returnValue;

    public AbstractBillingRequestMessage(Class<T> returnType, String method, Class<? extends Serializable>[] parameterTypes, Serializable[] parameters) {
        super(true);
        this.returnType = returnType;
        Preconditions.checkNotNull(this.returnType);
        this.method = method;
        Preconditions.checkNotNull((Object)this.method);
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBillingRequestMessage other = (AbstractBillingRequestMessage)obj;
        return Objects.equal((Object)this.method, (Object)other.method) && Objects.equal((Object)this.parameters, (Object)other.parameters) && Objects.equal(this.parameterTypes, other.parameterTypes) && Objects.equal(this.returnType, other.returnType);
    }

    public String getMethod() {
        return this.method;
    }

    public Serializable[] getParameters() {
        return this.parameters;
    }

    public Class<? extends Serializable>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public T getReturnValue() {
        return this.returnValue;
    }

    public Object[] getParameterValues() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.method, this.parameters, this.parameterTypes, this.returnType});
    }

    public void setReturnValue(T returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public String toString() {
        return "BillingRequest{" + this.method + (this.parameterTypes == null ? "" : Arrays.asList(this.parameterTypes)) + (this.parameters == null ? "" : Arrays.asList(this.parameters)) + ", return type " + this.returnType + "}{" + super.toString() + "}";
    }
}

