/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.htpasswd;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.htpasswd.MD5Crypt;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtpasswdPlugin
implements GPlazmaAuthenticationPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtpasswdPlugin.class);
    private final Supplier<Stream<String>> htpasswdFile;
    private Map<String, String> users = Collections.emptyMap();

    public HtpasswdPlugin(Properties properties) {
        this(new FileSupplier(Paths.get(properties.getProperty("gplazma.htpasswd.file"), new String[0]), HtpasswdPlugin.getMillis(properties, "gplazma.htpasswd.file.cache-period"), StandardCharsets.US_ASCII));
    }

    public HtpasswdPlugin(Supplier<Stream<String>> htpasswdFile) {
        this.htpasswdFile = htpasswdFile;
    }

    private synchronized String getHash(String user) throws IOException {
        try (Stream<String> stream = this.htpasswdFile.get();){
            if (stream != null) {
                this.users = stream.map(s -> s.split(":", 2)).collect(Collectors.toMap(e -> e[0], e -> e[1].trim(), (a, b) -> b));
            }
        }
        return this.users.get(user);
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        try {
            PasswordCredential credential = (PasswordCredential)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, PasswordCredential.class), null);
            Preconditions.checkAuthentication((credential != null ? 1 : 0) != 0, (String)"no username and password");
            String name = credential.getUsername();
            String hash = this.getHash(name);
            Preconditions.checkAuthentication((hash != null ? 1 : 0) != 0, (String)(name + " is unknown"));
            Preconditions.checkAuthentication((boolean)MD5Crypt.verifyPassword(credential.getPassword(), hash), (String)"wrong password");
            identifiedPrincipals.add((Principal)new UserNamePrincipal(name));
        }
        catch (IOException e) {
            throw new AuthenticationException("Authentication failed due to I/O error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static long getMillis(Properties properties, String key) {
        return TimeUnit.valueOf(properties.getProperty(key + ".unit")).toMillis(Long.parseLong(properties.getProperty(key)));
    }

    private static class FileSupplier
    implements Supplier<Stream<String>> {
        private final long refreshPeriod;
        private final Path file;
        private final Charset charset;
        private long lastCheckedAt;

        public FileSupplier(Path file, long refreshPeriod, Charset charset) {
            this.refreshPeriod = refreshPeriod;
            this.file = file;
            this.charset = charset;
        }

        @Override
        public Stream<String> get() {
            Stream<String> lines = null;
            long now = System.currentTimeMillis();
            if (this.lastCheckedAt + this.refreshPeriod <= now) {
                try {
                    FileTime lastModified = Files.getLastModifiedTime(this.file, new LinkOption[0]);
                    if (this.lastCheckedAt <= lastModified.toMillis()) {
                        lines = Files.lines(this.file, this.charset);
                    }
                    this.lastCheckedAt = now;
                }
                catch (IOException e) {
                    LOGGER.warn("{} cannot be opened: {}", (Object)this.file, (Object)e.getMessage());
                }
            }
            return lines;
        }
    }
}

