/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;

public class MutatorPlugin
implements GPlazmaMappingPlugin {
    private final ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    static final String IN_OPTION = "gplazma.mutator.accept";
    static final String OUT_OPTION = "gplazma.mutator.produce";
    private final Class<? extends Principal> inPrincipal;
    private final Class<? extends Principal> outPrincipal;
    private Constructor<? extends Principal> outConstructor;

    public MutatorPlugin(Properties properties) throws ClassNotFoundException, NoSuchMethodException {
        String inClass = properties.getProperty(IN_OPTION);
        String outClass = properties.getProperty(OUT_OPTION);
        Preconditions.checkArgument((inClass != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.mutator.accept");
        Preconditions.checkArgument((outClass != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.mutator.produce");
        Class<?> principal = this.classLoader.loadClass(inClass);
        Preconditions.checkArgument((boolean)Principal.class.isAssignableFrom(principal), (Object)(inClass + " is not a Principal"));
        this.inPrincipal = principal;
        this.outPrincipal = MutatorPlugin.classOf(outClass);
        this.outConstructor = this.outPrincipal.getConstructor(String.class);
    }

    public void map(Set<Principal> principals) {
        HashSet<Principal> mutated = new HashSet<Principal>();
        for (Principal p : Iterables.filter(principals, this.inPrincipal)) {
            try {
                Principal out = this.outConstructor.newInstance(p.getName());
                mutated.add(out);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {}
        }
        principals.addAll(mutated);
    }

    public static Class<? extends Principal> classOf(String type) {
        switch (type) {
            case "dn": {
                return GlobusPrincipal.class;
            }
            case "kerberos": {
                return KerberosPrincipal.class;
            }
            case "fqan": {
                return FQANPrincipal.class;
            }
            case "name": {
                return LoginNamePrincipal.class;
            }
            case "username": {
                return UserNamePrincipal.class;
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }
}

