/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.slf4j.helpers.Util;

class Log4jLoggerFactory {
    private static ConcurrentMap<String, Logger> log4jLoggers = new ConcurrentHashMap<String, Logger>();
    private static final String LOG4J_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#log4jDelegationLoop";

    Log4jLoggerFactory() {
    }

    public static Logger getLogger(String name2) {
        Logger instance = (Logger)log4jLoggers.get(name2);
        if (instance != null) {
            return instance;
        }
        Logger newInstance = new Logger(name2);
        Logger oldInstance = log4jLoggers.putIfAbsent(name2, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    public static Logger getLogger(String name2, LoggerFactory loggerFactory) {
        Logger instance = (Logger)log4jLoggers.get(name2);
        if (instance != null) {
            return instance;
        }
        Logger newInstance = loggerFactory.makeNewLoggerInstance(name2);
        Logger oldInstance = log4jLoggers.putIfAbsent(name2, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    static {
        try {
            Class.forName("org.slf4j.impl.Log4jLoggerFactory");
            String part1 = "Detected both log4j-over-slf4j.jar AND slf4j-log4j12.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#log4jDelegationLoop for more details.";
            Util.report(part1);
            Util.report(part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

