/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.store;

public final class RetentionPolicy {
    private final String _name;
    private final int _id;
    public static final RetentionPolicy REPLICA = new RetentionPolicy("REPLICA", 2);
    public static final RetentionPolicy OUTPUT = new RetentionPolicy("OUTPUT", 1);
    public static final RetentionPolicy CUSTODIAL = new RetentionPolicy("CUSTODIAL", 0);

    private RetentionPolicy(String name2, int id) {
        this._name = name2;
        this._id = id;
    }

    public static RetentionPolicy[] getAllPoliciess() {
        return new RetentionPolicy[]{REPLICA, OUTPUT, CUSTODIAL};
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static RetentionPolicy valueOf(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (RetentionPolicy.REPLICA._name.equalsIgnoreCase(state)) {
            return REPLICA;
        }
        if (RetentionPolicy.OUTPUT._name.equalsIgnoreCase(state)) {
            return OUTPUT;
        }
        if (RetentionPolicy.CUSTODIAL._name.equalsIgnoreCase(state)) {
            return CUSTODIAL;
        }
        try {
            int id = Integer.parseInt(state);
            return RetentionPolicy.valueOf(id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown State");
        }
    }

    public static RetentionPolicy valueOf(int id) throws IllegalArgumentException {
        if (RetentionPolicy.REPLICA._id == id) {
            return REPLICA;
        }
        if (RetentionPolicy.OUTPUT._id == id) {
            return OUTPUT;
        }
        if (RetentionPolicy.CUSTODIAL._id == id) {
            return CUSTODIAL;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }

    public boolean equals(Object obj) {
        return obj instanceof RetentionPolicy && ((RetentionPolicy)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._id;
    }
}

