/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.dcache.nfs.status.LayoutUnavailableException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.Layout;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.RoundRobinStripingPattern;
import org.dcache.nfs.v4.StripingPattern;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layout4;
import org.dcache.nfs.v4.xdr.multipath_list4;
import org.dcache.nfs.v4.xdr.netaddr4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfsv4_1_file_layout_ds_addr4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.utils.Bytes;
import org.dcache.utils.net.InetSocketAddresses;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager
implements NFSv41DeviceManager {
    private static final deviceid4 MDS_ID = DeviceManager.deviceidOf(0);
    private static final Logger _log = LoggerFactory.getLogger(DeviceManager.class);
    private final Random _deviceIdGenerator = new Random();
    private final Map<deviceid4, device_addr4> _deviceMap = new ConcurrentHashMap<deviceid4, device_addr4>();
    private InetSocketAddress[] _knownDataServers;
    private final StripingPattern<InetSocketAddress> _stripingPattern = new RoundRobinStripingPattern<InetSocketAddress>();

    public void setDataservers(String[] servers) {
        this._knownDataServers = new InetSocketAddress[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            this._knownDataServers[i] = InetSocketAddresses.inetAddressOf(servers[i]);
        }
    }

    private int nextDeviceID() {
        return this._deviceIdGenerator.nextInt(255) + 1;
    }

    @Override
    public Layout layoutGet(CompoundContext context, Inode inode, int layoutType, int ioMode, stateid4 stateid) throws IOException {
        deviceid4 deviceId;
        if (layoutType != 1) {
            throw new LayoutUnavailableException("layout not supported");
        }
        if (!context.getFs().hasIOLayout(inode)) {
            deviceId = MDS_ID;
        } else {
            if (this._knownDataServers.length == 0) {
                throw new LayoutUnavailableException("No dataservers available");
            }
            int id = this.nextDeviceID();
            deviceId = DeviceManager.deviceidOf(id);
            _log.debug("generating new device: {} ({}) for stateid {}", deviceId, id, stateid);
            device_addr4 deviceAddr = DeviceManager.deviceAddrOf(this._stripingPattern, this._knownDataServers);
            this._deviceMap.put(deviceId, deviceAddr);
        }
        nfs_fh4 fh = new nfs_fh4(context.currentInode().toNfsHandle());
        layout4 layout = Layout.getLayoutSegment(deviceId, 0x400000, fh, ioMode, 0L, -1L);
        return new Layout(true, stateid, new layout4[]{layout});
    }

    @Override
    public device_addr4 getDeviceInfo(CompoundContext context, deviceid4 deviceId) {
        _log.debug("lookup for device: {}", (Object)deviceId);
        if (deviceId.equals(MDS_ID)) {
            return DeviceManager.deviceAddrOf(this._stripingPattern, context.getLocalSocketAddress());
        }
        return this._deviceMap.get(deviceId);
    }

    @Override
    public List<deviceid4> getDeviceList(CompoundContext context) {
        return new ArrayList<deviceid4>(this._deviceMap.keySet());
    }

    @Override
    public void layoutReturn(CompoundContext context, stateid4 stateid) {
        _log.debug("release device for stateid {}", (Object)stateid);
    }

    public static device_addr4 deviceAddrOf(StripingPattern<InetSocketAddress> stripingPattern, InetSocketAddress ... deviceAddress) {
        nfsv4_1_file_layout_ds_addr4 file_type = new nfsv4_1_file_layout_ds_addr4();
        file_type.nflda_multipath_ds_list = new multipath_list4[deviceAddress.length];
        for (int i = 0; i < deviceAddress.length; ++i) {
            file_type.nflda_multipath_ds_list[i] = new multipath_list4();
            file_type.nflda_multipath_ds_list[i].value = new netaddr4[1];
            file_type.nflda_multipath_ds_list[i].value[0] = new netaddr4(deviceAddress[i]);
        }
        file_type.nflda_stripe_indices = stripingPattern.getPattern((InetSocketAddress[])deviceAddress);
        XdrBuffer xdr = new XdrBuffer(128);
        try {
            xdr.beginEncoding();
            file_type.xdrEncode(xdr);
            xdr.endEncoding();
        }
        catch (OncRpcException e) {
            throw new RuntimeException("Unexpected OncRpcException:", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException:", e);
        }
        Buffer body = xdr.asBuffer();
        byte[] retBytes = new byte[body.remaining()];
        body.get(retBytes);
        device_addr4 addr = new device_addr4();
        addr.da_layout_type = 1;
        addr.da_addr_body = retBytes;
        return addr;
    }

    private static deviceid4 deviceidOf(int id) {
        byte[] deviceidBytes = new byte[16];
        Bytes.putInt(deviceidBytes, 0, id);
        return new deviceid4(deviceidBytes);
    }
}

