/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSeqidException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.CompleteAlreadyException;
import org.dcache.nfs.status.ExpiredException;
import org.dcache.nfs.status.ResourceException;
import org.dcache.nfs.status.SeqMisorderedException;
import org.dcache.nfs.v4.ClientCB;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.xdr.seqid4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFS4Client {
    private static final Logger _log = LoggerFactory.getLogger(NFS4Client.class);
    private static final long BOOTID = System.currentTimeMillis() / 1000L;
    private static final AtomicInteger CLIENTID = new AtomicInteger(0);
    private final byte[] _ownerId;
    private final verifier4 _verifier;
    private final Principal _principal;
    private final long _clientId;
    private boolean _isConfirmed = false;
    private int _openStateId = 1;
    private seqid4 _clientSeq;
    private int _sessionSequence = 1;
    private final Map<stateid4, NFS4State> _clientStates = new ConcurrentHashMap<stateid4, NFS4State>();
    private final int MAX_OPEN_STATES = 16384;
    private final Map<Integer, NFSv41Session> _sessions = new HashMap<Integer, NFSv41Session>();
    private long _cl_time = System.currentTimeMillis();
    private final InetSocketAddress _clientAddress;
    private final InetSocketAddress _localAddress;
    private ClientCB _cl_cb = null;
    private final long _leaseTime;
    private boolean _disposed;
    private boolean _reclaim_completed;

    public NFS4Client(InetSocketAddress clientAddress, InetSocketAddress localAddress, byte[] ownerID, verifier4 verifier, Principal principal, long leaseTime) {
        this._ownerId = ownerID;
        this._verifier = verifier;
        this._principal = principal;
        this._clientId = BOOTID << 32 | (long)CLIENTID.incrementAndGet();
        this._clientAddress = clientAddress;
        this._localAddress = localAddress;
        this._leaseTime = leaseTime;
        this._reclaim_completed = false;
        _log.debug("New client id: {}", (Object)Long.toHexString(this._clientId));
    }

    public void setCB(ClientCB cb) {
        this._cl_cb = cb;
    }

    public ClientCB getCB() {
        return this._cl_cb;
    }

    public boolean isOwner(byte[] other) {
        return Arrays.equals(this._ownerId, other);
    }

    public verifier4 verifier() {
        return this._verifier;
    }

    public long getId() {
        return this._clientId;
    }

    public boolean verifierEquals(verifier4 verifier) {
        return this._verifier.equals(verifier);
    }

    public boolean isConfirmed() {
        return this._isConfirmed;
    }

    public void setConfirmed() {
        this._isConfirmed = true;
    }

    public boolean isLeaseValid() {
        return System.currentTimeMillis() - this._cl_time < this._leaseTime;
    }

    public void updateLeaseTime() throws ChimeraNFSException {
        long curentTime = System.currentTimeMillis();
        if (curentTime - this._cl_time > this._leaseTime) {
            this._clientStates.clear();
            throw new ExpiredException("lease time expired");
        }
        this._cl_time = curentTime;
    }

    public void refreshLeaseTime() {
        this._cl_time = System.currentTimeMillis();
    }

    public synchronized void reset() {
        this.refreshLeaseTime();
        this._isConfirmed = false;
        this._clientSeq = null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this._clientAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public int currentSeqID() {
        return this._sessionSequence;
    }

    public NFS4State createState() throws ChimeraNFSException {
        if (this._clientStates.size() >= 16384) {
            throw new ResourceException("Too many states.");
        }
        NFS4State state = new NFS4State(this._clientId, this._openStateId);
        ++this._openStateId;
        this._clientStates.put(state.stateid(), state);
        return state;
    }

    public synchronized void validateSequence(seqid4 openSeqid) throws BadSeqidException {
        if (this._clientSeq == null) {
            this._clientSeq = openSeqid;
        } else {
            int next = this._clientSeq.value.value + 1;
            if (next != openSeqid.value.value) {
                throw new BadSeqidException();
            }
            this._clientSeq.value.value = next;
        }
    }

    public void releaseState(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.remove(stateid);
        if (state == null) {
            throw new BadStateidException("State not known to the client.");
        }
        state.tryDispose();
    }

    public NFS4State state(stateid4 stateid) throws ChimeraNFSException {
        NFS4State state = this._clientStates.get(stateid);
        if (state == null) {
            throw new BadStateidException("State not known to the client.");
        }
        return state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._clientAddress).append(":").append(this._ownerId).append("@").append(this._clientId);
        return sb.toString();
    }

    public Collection<NFSv41Session> sessions() {
        return this._sessions.values();
    }

    public NFSv41Session createSession(int sequence, int cacheSize, int cbCacheSize, int maxOps, int maxCbOps) throws ChimeraNFSException {
        _log.debug("session for sequience: {}", (Object)sequence);
        if (sequence > this._sessionSequence && this._isConfirmed) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1 && !this._isConfirmed) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        if (sequence == this._sessionSequence - 1) {
            _log.debug("Retransmit on create session detected");
            return this._sessions.get(sequence);
        }
        if (sequence != this._sessionSequence) {
            throw new SeqMisorderedException("bad sequence id: " + this._sessionSequence + " / " + sequence);
        }
        NFSv41Session session = new NFSv41Session(this, this._sessionSequence, cacheSize, cbCacheSize, maxOps, maxCbOps);
        this._sessions.put(this._sessionSequence, session);
        ++this._sessionSequence;
        if (!this._isConfirmed) {
            this._isConfirmed = true;
            _log.debug("set client confirmed");
        }
        return session;
    }

    public void removeSession(NFSv41Session session) {
        this._sessions.remove(session.getSequence());
    }

    public boolean hasSessions() {
        return !this._sessions.isEmpty();
    }

    public Principal principal() {
        return this._principal;
    }

    public boolean hasState() {
        return !this._clientStates.isEmpty();
    }

    public void attachState(NFS4State state) {
        this._clientStates.put(state.stateid(), state);
    }

    public void detachState(NFS4State state) {
        this._clientStates.remove(state.stateid());
    }

    public final void tryDispose() {
        if (!this._disposed) {
            this.dispose();
            this._disposed = true;
        }
    }

    protected void dispose() {
        this._clientStates.values().forEach(state -> state.tryDispose());
    }

    public synchronized void reclaimComplete() throws ChimeraNFSException {
        if (this._reclaim_completed) {
            throw new CompleteAlreadyException("Duplicating reclaim");
        }
        this._reclaim_completed = true;
    }

    public synchronized boolean needReclaim() {
        return !this._reclaim_completed;
    }
}

