/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSessionException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.utils.Bytes;
import org.dcache.utils.Cache;
import org.dcache.utils.NopCacheEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv4StateHandler {
    private static final Logger _log = LoggerFactory.getLogger(NFSv4StateHandler.class);
    private final Map<Long, NFS4Client> _clientsByServerId = new HashMap<Long, NFS4Client>();
    private final Cache<sessionid4, NFSv41Session> _sessionById;
    private final long _leaseTime;
    private boolean _running;

    public NFSv4StateHandler() {
        this(90L);
    }

    NFSv4StateHandler(long leaseTime) {
        this._leaseTime = TimeUnit.SECONDS.toMillis(leaseTime);
        this._sessionById = new Cache<sessionid4, NFSv41Session>("NFSv41 sessions", 5000, Long.MAX_VALUE, this._leaseTime * 2L, new DeadSessionCollector(), this._leaseTime * 4L, TimeUnit.MILLISECONDS);
        this._running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(NFS4Client client) {
        NFSv4StateHandler nFSv4StateHandler = this;
        synchronized (nFSv4StateHandler) {
            Preconditions.checkState(this._running, "NFS state handler not running");
            client.sessions().forEach(s -> this._sessionById.remove(s.id()));
            this._clientsByServerId.remove(client.getId());
        }
        client.tryDispose();
    }

    private synchronized void addClient(NFS4Client newClient) {
        Preconditions.checkState(this._running, "NFS state handler not running");
        this._clientsByServerId.put(newClient.getId(), newClient);
    }

    public synchronized NFS4Client getClientByID(Long id) throws ChimeraNFSException {
        Preconditions.checkState(this._running, "NFS state handler not running");
        NFS4Client client = this._clientsByServerId.get(id);
        if (client == null) {
            throw new StaleClientidException("bad client id.");
        }
        return client;
    }

    public synchronized NFS4Client getClientIdByStateId(stateid4 stateId) throws ChimeraNFSException {
        Preconditions.checkState(this._running, "NFS state handler not running");
        NFS4Client client = this._clientsByServerId.get(Bytes.getLong(stateId.other, 0));
        if (client == null) {
            throw new BadStateidException("no client for stateid.");
        }
        return client;
    }

    public synchronized NFSv41Session getSession(sessionid4 id) {
        Preconditions.checkState(this._running, "NFS state handler not running");
        return this._sessionById.get(id);
    }

    public synchronized NFSv41Session removeSession(sessionid4 id) throws ChimeraNFSException {
        NFSv41Session session = this._sessionById.remove(id);
        if (session == null) {
            throw new BadSessionException("session not found");
        }
        this.detachSession(session);
        return session;
    }

    public synchronized void addSession(NFSv41Session session) {
        Preconditions.checkState(this._running, "NFS state handler not running");
        this._sessionById.put(session.id(), session);
    }

    public synchronized NFS4Client clientByOwner(byte[] ownerid) {
        for (NFS4Client client : this._clientsByServerId.values()) {
            if (!client.isOwner(ownerid)) continue;
            return client;
        }
        return null;
    }

    public void updateClientLeaseTime(stateid4 stateid) throws ChimeraNFSException {
        Preconditions.checkState(this._running, "NFS state handler not running");
        NFS4Client client = this.getClientIdByStateId(stateid);
        NFS4State state = client.state(stateid);
        if (!state.isConfimed()) {
            throw new BadStateidException("State is not confirmed");
        }
        Stateids.checkStateId(state.stateid(), stateid);
        client.updateLeaseTime();
    }

    public synchronized List<NFS4Client> getClients() {
        Preconditions.checkState(this._running, "NFS state handler not running");
        return new ArrayList<NFS4Client>(this._clientsByServerId.values());
    }

    public NFS4Client createClient(InetSocketAddress clientAddress, InetSocketAddress localAddress, byte[] ownerID, verifier4 verifier, Principal principal) {
        NFS4Client client = new NFS4Client(clientAddress, localAddress, ownerID, verifier, principal, this._leaseTime);
        this.addClient(client);
        return client;
    }

    private void detachSession(NFSv41Session session) {
        NFS4Client client = session.getClient();
        client.removeSession(session);
        if (!client.hasSessions()) {
            this.removeClient(client);
        }
    }

    public boolean hasGracePeriodExpired() {
        Preconditions.checkState(this._running, "NFS state handler not running");
        return true;
    }

    public synchronized void shutdown() {
        Preconditions.checkState(this._running, "NFS state handler not running");
        this._running = false;
        this._sessionById.shutdown();
    }

    private class DeadSessionCollector
    extends NopCacheEventListener<sessionid4, NFSv41Session> {
        private DeadSessionCollector() {
        }

        @Override
        public void notifyExpired(Cache<sessionid4, NFSv41Session> cache, NFSv41Session session) {
            _log.info("Removing expired session: {}", (Object)session);
            NFSv4StateHandler.this.detachSession(session);
        }
    }
}

