/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.InodeCacheEntry;
import org.dcache.nfs.status.BadCookieException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.TooSmallException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.xdr.READDIR4res;
import org.dcache.nfs.v4.xdr.READDIR4resok;
import org.dcache.nfs.v4.xdr.component4;
import org.dcache.nfs.v4.xdr.dirlist4;
import org.dcache.nfs.v4.xdr.entry4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_cookie4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.utils.Bytes;
import org.dcache.utils.GuavaCacheMXBean;
import org.dcache.utils.GuavaCacheMXBeanImpl;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREADDIR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREADDIR.class);
    private static final int ENTRY4_SIZE = 36;
    private static final int DIRLIST4_SIZE = 56;
    private static final int READDIR4RESOK_SIZE = 92;
    private static final long COOKIE_OFFSET = 3L;
    private static final Cache<InodeCacheEntry<verifier4>, List<DirectoryEntry>> _dlCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).softValues().maximumSize(512L).recordStats().build();
    private static final GuavaCacheMXBean CACHE_MXBEAN = new GuavaCacheMXBeanImpl("READDIR4", _dlCache);

    OperationREADDIR(nfs_argop4 args) {
        super(args, 26);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        List dirList;
        verifier4 verifier;
        READDIR4res res = result.opreaddir;
        Inode dir = context.currentInode();
        long startValue = this._args.opreaddir.cookie.value;
        if (startValue == 1L || startValue == 2L) {
            throw new BadCookieException("bad cookie : " + startValue);
        }
        if (startValue != 0L) {
            verifier = this._args.opreaddir.cookieverf;
            dirList = _dlCache.getIfPresent(new InodeCacheEntry<verifier4>(dir, verifier));
            if (dirList == null) {
                throw new BadCookieException("readdir verifier expired");
            }
            if (++startValue > (long)dirList.size() + 3L || startValue < 3L) {
                throw new BadCookieException("bad cookie : " + startValue + " " + dirList.size());
            }
        } else {
            Stat stat = context.getFs().getattr(dir);
            if (stat.type() != Stat.Type.DIRECTORY) {
                throw new NotDirException();
            }
            verifier = this.generateDirectoryVerifier(stat);
            startValue = 3L;
            InodeCacheEntry<verifier4> cacheKey = new InodeCacheEntry<verifier4>(dir, verifier);
            try {
                dirList = _dlCache.get(cacheKey, () -> context.getFs().list(dir));
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf(e.getCause(), ChimeraNFSException.class);
                throw new NfsIoException(e.getMessage());
            }
        }
        if (this._args.opreaddir.maxcount.value < 92) {
            throw new TooSmallException("maxcount too small");
        }
        res.resok4 = new READDIR4resok();
        res.resok4.reply = new dirlist4();
        res.resok4.cookieverf = verifier;
        int currcount = 92;
        int dircount = 0;
        entry4 currentEntry = res.resok4.reply.entries = new entry4();
        entry4 lastEntry = null;
        res.resok4.reply.eof = true;
        int fcount = 0;
        for (long i = startValue; i < (long)dirList.size() + 3L; ++i) {
            DirectoryEntry le = (DirectoryEntry)dirList.get((int)(i - 3L));
            String name2 = le.getName();
            if (name2.equals(".") || name2.equals("..")) continue;
            ++fcount;
            Inode ei = le.getInode();
            currentEntry.name = new component4(name2);
            currentEntry.cookie = new nfs_cookie4(i);
            currentEntry.attrs = OperationGETATTR.getAttributes(this._args.opreaddir.attr_request, context.getFs(), ei, le.getStat(), context);
            currentEntry.nextentry = null;
            int newSize = 36 + name2.length() + currentEntry.name.value.length + currentEntry.attrs.attr_vals.value.length;
            int newDirSize = name2.length() + 4;
            if (currcount + newSize > this._args.opreaddir.maxcount.value || dircount + newDirSize > this._args.opreaddir.dircount.value) {
                res.resok4.reply.eof = false;
                _log.debug("Sending {} entries ({} bytes from {}, dircount = {} from {} ) cookie = {} total {}", i - startValue, currcount, this._args.opreaddir.maxcount.value, dircount, this._args.opreaddir.dircount.value, startValue, dirList.size());
                break;
            }
            dircount += newDirSize;
            currcount += newSize;
            lastEntry = currentEntry;
            if (i + 1L >= (long)dirList.size() + 3L) continue;
            currentEntry = currentEntry.nextentry = new entry4();
        }
        if (lastEntry == null) {
            res.resok4.reply.entries = null;
        } else {
            lastEntry.nextentry = null;
        }
        res.status = 0;
        _log.debug("Sending {} entries ({} bytes from {}, dircount = {} from {} ) cookie = {} total {} EOF={}", fcount, currcount, this._args.opreaddir.maxcount.value, startValue, this._args.opreaddir.dircount.value, dirList.size(), res.resok4.reply.eof);
    }

    private verifier4 generateDirectoryVerifier(Stat stat) throws IllegalArgumentException, IOException {
        byte[] verifier = new byte[8];
        Bytes.putLong(verifier, 0, stat.getGeneration());
        return new verifier4(verifier);
    }
}

