/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.xdr.ClientTransport;
import org.dcache.xdr.GrizzlyUtils;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcProtocolFilter;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcClient {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcClient.class);
    private final InetSocketAddress _socketAddress;
    private final Transport _transport;
    private Connection<InetSocketAddress> _connection;
    private final ReplyQueue<Integer, RpcReply> _replyQueue = new ReplyQueue();

    public OncRpcClient(InetAddress address, int protocol, int port) {
        this(new InetSocketAddress(address, port), protocol);
    }

    public OncRpcClient(InetSocketAddress socketAddress, int protocol) {
        this._socketAddress = socketAddress;
        if (protocol == 6) {
            this._transport = TCPNIOTransportBuilder.newInstance().build();
        } else if (protocol == 17) {
            this._transport = UDPNIOTransportBuilder.newInstance().build();
        } else {
            throw new IllegalArgumentException("Unsupported protocol type: " + protocol);
        }
        FilterChainBuilder filterChain = FilterChainBuilder.stateless();
        filterChain.add(new TransportFilter());
        filterChain.add(GrizzlyUtils.rpcMessageReceiverFor(this._transport));
        filterChain.add(new RpcProtocolFilter(this._replyQueue));
        this._transport.setProcessor(filterChain.build());
        this._transport.setIOStrategy(SameThreadIOStrategy.getInstance());
    }

    public XdrTransport connect() throws IOException {
        return this.connect(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public XdrTransport connect(long timeout, TimeUnit timeUnit) throws IOException {
        this._transport.start();
        Future<Connection> future = ((ConnectorHandler)((Object)this._transport)).connect(this._socketAddress);
        try {
            this._connection = future.get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            throw new IOException(e.toString(), e);
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.toString(), e);
        }
        return new ClientTransport(this._connection, this._replyQueue);
    }

    public void close() throws IOException {
        this._transport.shutdownNow();
    }
}

