/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.objectweb.asm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.pfl.objectweb.asm.AnnotationVisitor;
import org.glassfish.pfl.objectweb.asm.Attribute;
import org.glassfish.pfl.objectweb.asm.Label;
import org.glassfish.pfl.objectweb.asm.MethodAdapter;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.objectweb.asm.Opcodes;
import org.glassfish.pfl.objectweb.asm.Type;
import org.glassfish.pfl.objectweb.asm.tree.MethodNode;
import org.glassfish.pfl.objectweb.asm.tree.analysis.Analyzer;
import org.glassfish.pfl.objectweb.asm.tree.analysis.BasicVerifier;
import org.glassfish.pfl.objectweb.asm.util.CheckAnnotationAdapter;
import org.glassfish.pfl.objectweb.asm.util.CheckClassAdapter;

public class CheckMethodAdapter
extends MethodAdapter {
    public int version;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private final Map labels;
    private static final int[] TYPE;
    private static Field labelStatusField;

    public CheckMethodAdapter(MethodVisitor mv) {
        this(mv, new HashMap());
    }

    public CheckMethodAdapter(MethodVisitor mv, Map labels) {
        super(mv);
        this.labels = labels;
    }

    public CheckMethodAdapter(int access, String name2, String desc, final MethodVisitor mv, Map labels) {
        this(new MethodNode(access, name2, desc, null, null){

            @Override
            public void visitEnd() {
                Analyzer a = new Analyzer(new BasicVerifier());
                try {
                    a.analyze("dummy", this);
                }
                catch (Exception e) {
                    if (e instanceof IndexOutOfBoundsException && this.maxLocals == 0 && this.maxStack == 0) {
                        throw new RuntimeException("Data flow checking option requires valid, non zero maxLocals and maxStack values.");
                    }
                    e.printStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    CheckClassAdapter.printAnalyzerResult(this, a, pw);
                    pw.close();
                    throw new RuntimeException(e.getMessage() + ' ' + sw.toString());
                }
                this.accept(mv);
            }
        }, labels);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.mv.visitAnnotation(desc, visible));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(this.mv.visitAnnotationDefault(), false);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.mv.visitParameterAnnotation(parameter, desc, visible));
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.checkEndMethod();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.mv.visitAttribute(attr);
    }

    @Override
    public void visitCode() {
        this.startCode = true;
        this.mv.visitCode();
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int i;
        int mStack;
        int mLocal;
        switch (type) {
            case -1: 
            case 0: {
                mLocal = Integer.MAX_VALUE;
                mStack = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                mLocal = 0;
                mStack = 0;
                break;
            }
            case 4: {
                mLocal = 0;
                mStack = 1;
                break;
            }
            case 1: 
            case 2: {
                mLocal = 3;
                mStack = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + type);
            }
        }
        if (nLocal > mLocal) {
            throw new IllegalArgumentException("Invalid nLocal=" + nLocal + " for frame type " + type);
        }
        if (nStack > mStack) {
            throw new IllegalArgumentException("Invalid nStack=" + nStack + " for frame type " + type);
        }
        if (type != 2) {
            if (nLocal > 0 && (local == null || local.length < nLocal)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (i = 0; i < nLocal; ++i) {
                CheckMethodAdapter.checkFrameValue(local[i]);
            }
        }
        if (nStack > 0 && (stack == null || stack.length < nStack)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (i = 0; i < nStack; ++i) {
            CheckMethodAdapter.checkFrameValue(stack[i]);
        }
        this.mv.visitFrame(type, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 0);
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 1);
        switch (opcode) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(operand, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(operand, "Invalid operand");
                break;
            }
            default: {
                if (operand >= 4 && operand <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + operand);
            }
        }
        this.mv.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 2);
        CheckMethodAdapter.checkUnsignedShort(var, "Invalid variable index");
        this.mv.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 3);
        CheckMethodAdapter.checkInternalName(type, "type");
        if (opcode == 187 && type.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + type);
        }
        this.mv.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name2, String desc) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 4);
        CheckMethodAdapter.checkInternalName(owner, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDesc(desc, false);
        this.mv.visitFieldInsn(opcode, owner, name2, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name2, String desc) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 5);
        CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "name");
        CheckMethodAdapter.checkInternalName(owner, "owner");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (opcode == 186 && owner != "java/lang/dyn/Dynamic") {
            throw new IllegalArgumentException("INVOKEDYNAMIC cannot be used with another owner than INVOKEDYNAMIC_OWNER");
        }
        this.mv.visitMethodInsn(opcode, owner, name2, desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        this.mv.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.mv.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.checkStartCode();
        this.checkEndCode();
        if (!(cst instanceof Type)) {
            CheckMethodAdapter.checkConstant(cst);
        }
        this.mv.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(var, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(increment, "Invalid increment");
        this.mv.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.checkStartCode();
        this.checkEndCode();
        if (max < min) {
            throw new IllegalArgumentException("Max = " + max + " must be greater than or equal to min = " + min);
        }
        this.checkLabel(dflt, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(dflt);
        if (labels == null || labels.length != max - min + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labels.length; ++i) {
            this.checkLabel(labels[i], false, "label at index " + i);
            CheckMethodAdapter.checkNonDebugLabel(labels[i]);
        }
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(dflt, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(dflt);
        if (keys == null || labels == null || keys.length != labels.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labels.length; ++i) {
            this.checkLabel(labels[i], false, "label at index " + i);
            CheckMethodAdapter.checkNonDebugLabel(labels[i]);
        }
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(desc, false);
        if (desc.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + desc);
        }
        if (dims < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + dims);
        }
        if (dims > desc.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + dims);
        }
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(start, false, "start label");
        this.checkLabel(end, false, "end label");
        this.checkLabel(handler, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(start);
        CheckMethodAdapter.checkNonDebugLabel(end);
        CheckMethodAdapter.checkNonDebugLabel(handler);
        if (this.labels.get(start) != null || this.labels.get(end) != null || this.labels.get(handler) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (type != null) {
            CheckMethodAdapter.checkInternalName(type, "type");
        }
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDesc(desc, false);
        this.checkLabel(start, true, "start label");
        this.checkLabel(end, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(index, "Invalid variable index");
        int s = (Integer)this.labels.get(start);
        int e = (Integer)this.labels.get(end);
        if (e < s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.mv.visitLocalVariable(name2, desc, signature, start, end, index);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(line, "Invalid line number");
        this.checkLabel(start, true, "start label");
        this.mv.visitLineNumber(line, start);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        CheckMethodAdapter.checkUnsignedShort(maxStack, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(maxLocals, "Invalid max locals");
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        this.mv.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    static void checkFrameValue(Object value) {
        if (value == Opcodes.TOP || value == Opcodes.INTEGER || value == Opcodes.FLOAT || value == Opcodes.LONG || value == Opcodes.DOUBLE || value == Opcodes.NULL || value == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (value instanceof String) {
            CheckMethodAdapter.checkInternalName((String)value, "Invalid stack frame value");
            return;
        }
        if (!(value instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + value);
        }
    }

    static void checkOpcode(int opcode, int type) {
        if (opcode < 0 || opcode > 199 || TYPE[opcode] != type) {
            throw new IllegalArgumentException("Invalid opcode: " + opcode);
        }
    }

    static void checkSignedByte(int value, String msg) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException(msg + " (must be a signed byte): " + value);
        }
    }

    static void checkSignedShort(int value, String msg) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException(msg + " (must be a signed short): " + value);
        }
    }

    static void checkUnsignedShort(int value, String msg) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException(msg + " (must be an unsigned short): " + value);
        }
    }

    static void checkConstant(Object cst) {
        if (!(cst instanceof Integer || cst instanceof Float || cst instanceof Long || cst instanceof Double || cst instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + cst);
        }
    }

    static void checkUnqualifiedName(int version, String name2, String msg) {
        if ((version & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(name2, msg);
        } else {
            for (int i = 0; i < name2.length(); ++i) {
                if (".;[/".indexOf(name2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + msg + " (must be a valid unqualified name): " + name2);
            }
        }
    }

    static void checkIdentifier(String name2, String msg) {
        CheckMethodAdapter.checkIdentifier(name2, 0, -1, msg);
    }

    static void checkIdentifier(String name2, int start, int end, String msg) {
        if (name2 == null || (end == -1 ? name2.length() <= start : end <= start)) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(name2.charAt(start))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name2);
        }
        int max = end == -1 ? name2.length() : end;
        for (int i = start + 1; i < max; ++i) {
            if (Character.isJavaIdentifierPart(name2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name2);
        }
    }

    static void checkMethodIdentifier(int version, String name2, String msg) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if ("<init>".equals(name2) || "<clinit>".equals(name2)) {
            return;
        }
        if ((version & 0xFFFF) >= 49) {
            for (int i = 0; i < name2.length(); ++i) {
                if (".;[/<>".indexOf(name2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + msg + " (must be a valid unqualified name): " + name2);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(name2.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + name2);
        }
        for (int i = 1; i < name2.length(); ++i) {
            if (Character.isJavaIdentifierPart(name2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + name2);
        }
    }

    static void checkInternalName(String name2, String msg) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (name2.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(name2, false);
        } else {
            CheckMethodAdapter.checkInternalName(name2, 0, -1, msg);
        }
    }

    static void checkInternalName(String name2, int start, int end, String msg) {
        int max = end == -1 ? name2.length() : end;
        try {
            int slash;
            int begin = start;
            do {
                if ((slash = name2.indexOf(47, begin + 1)) == -1 || slash > max) {
                    slash = max;
                }
                CheckMethodAdapter.checkIdentifier(name2, begin, slash, null);
                begin = slash + 1;
            } while (slash != max);
        }
        catch (IllegalArgumentException _) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a fully qualified class name in internal form): " + name2);
        }
    }

    static void checkDesc(String desc, boolean canBeVoid) {
        int end = CheckMethodAdapter.checkDesc(desc, 0, canBeVoid);
        if (end != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    static int checkDesc(String desc, int start, boolean canBeVoid) {
        if (desc == null || start >= desc.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (desc.charAt(start)) {
            case 'V': {
                if (canBeVoid) {
                    return start + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return start + 1;
            }
            case '[': {
                int index;
                for (index = start + 1; index < desc.length() && desc.charAt(index) == '['; ++index) {
                }
                if (index < desc.length()) {
                    return CheckMethodAdapter.checkDesc(desc, index, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'L': {
                int index = desc.indexOf(59, start);
                if (index == -1 || index - start < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                try {
                    CheckMethodAdapter.checkInternalName(desc, start + 1, index, null);
                }
                catch (IllegalArgumentException _) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                return index + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    static void checkMethodDesc(String desc) {
        if (desc == null || desc.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (desc.charAt(0) != '(' || desc.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
        int start = 1;
        if (desc.charAt(start) != ')') {
            do {
                if (desc.charAt(start) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            } while ((start = CheckMethodAdapter.checkDesc(desc, start, false)) < desc.length() && desc.charAt(start) != ')');
        }
        if ((start = CheckMethodAdapter.checkDesc(desc, start + 1, true)) != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    static void checkClassSignature(String signature) {
        int pos = 0;
        if (CheckMethodAdapter.getChar(signature, 0) == '<') {
            pos = CheckMethodAdapter.checkFormalTypeParameters(signature, pos);
        }
        pos = CheckMethodAdapter.checkClassTypeSignature(signature, pos);
        while (CheckMethodAdapter.getChar(signature, pos) == 'L') {
            pos = CheckMethodAdapter.checkClassTypeSignature(signature, pos);
        }
        if (pos != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos);
        }
    }

    static void checkMethodSignature(String signature) {
        int pos = 0;
        if (CheckMethodAdapter.getChar(signature, 0) == '<') {
            pos = CheckMethodAdapter.checkFormalTypeParameters(signature, pos);
        }
        pos = CheckMethodAdapter.checkChar('(', signature, pos);
        while ("ZCBSIFJDL[T".indexOf(CheckMethodAdapter.getChar(signature, pos)) != -1) {
            pos = CheckMethodAdapter.checkTypeSignature(signature, pos);
        }
        pos = CheckMethodAdapter.getChar(signature, pos = CheckMethodAdapter.checkChar(')', signature, pos)) == 'V' ? ++pos : CheckMethodAdapter.checkTypeSignature(signature, pos);
        while (CheckMethodAdapter.getChar(signature, pos) == '^') {
            if (CheckMethodAdapter.getChar(signature, ++pos) == 'L') {
                pos = CheckMethodAdapter.checkClassTypeSignature(signature, pos);
                continue;
            }
            pos = CheckMethodAdapter.checkTypeVariableSignature(signature, pos);
        }
        if (pos != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos);
        }
    }

    static void checkFieldSignature(String signature) {
        int pos = CheckMethodAdapter.checkFieldTypeSignature(signature, 0);
        if (pos != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos);
        }
    }

    private static int checkFormalTypeParameters(String signature, int pos) {
        pos = CheckMethodAdapter.checkChar('<', signature, pos);
        pos = CheckMethodAdapter.checkFormalTypeParameter(signature, pos);
        while (CheckMethodAdapter.getChar(signature, pos) != '>') {
            pos = CheckMethodAdapter.checkFormalTypeParameter(signature, pos);
        }
        return pos + 1;
    }

    private static int checkFormalTypeParameter(String signature, int pos) {
        pos = CheckMethodAdapter.checkIdentifier(signature, pos);
        if ("L[T".indexOf(CheckMethodAdapter.getChar(signature, pos = CheckMethodAdapter.checkChar(':', signature, pos))) != -1) {
            pos = CheckMethodAdapter.checkFieldTypeSignature(signature, pos);
        }
        while (CheckMethodAdapter.getChar(signature, pos) == ':') {
            pos = CheckMethodAdapter.checkFieldTypeSignature(signature, pos + 1);
        }
        return pos;
    }

    private static int checkFieldTypeSignature(String signature, int pos) {
        switch (CheckMethodAdapter.getChar(signature, pos)) {
            case 'L': {
                return CheckMethodAdapter.checkClassTypeSignature(signature, pos);
            }
            case '[': {
                return CheckMethodAdapter.checkTypeSignature(signature, pos + 1);
            }
        }
        return CheckMethodAdapter.checkTypeVariableSignature(signature, pos);
    }

    private static int checkClassTypeSignature(String signature, int pos) {
        pos = CheckMethodAdapter.checkChar('L', signature, pos);
        pos = CheckMethodAdapter.checkIdentifier(signature, pos);
        while (CheckMethodAdapter.getChar(signature, pos) == '/') {
            pos = CheckMethodAdapter.checkIdentifier(signature, pos + 1);
        }
        if (CheckMethodAdapter.getChar(signature, pos) == '<') {
            pos = CheckMethodAdapter.checkTypeArguments(signature, pos);
        }
        while (CheckMethodAdapter.getChar(signature, pos) == '.') {
            if (CheckMethodAdapter.getChar(signature, pos = CheckMethodAdapter.checkIdentifier(signature, pos + 1)) != '<') continue;
            pos = CheckMethodAdapter.checkTypeArguments(signature, pos);
        }
        return CheckMethodAdapter.checkChar(';', signature, pos);
    }

    private static int checkTypeArguments(String signature, int pos) {
        pos = CheckMethodAdapter.checkChar('<', signature, pos);
        pos = CheckMethodAdapter.checkTypeArgument(signature, pos);
        while (CheckMethodAdapter.getChar(signature, pos) != '>') {
            pos = CheckMethodAdapter.checkTypeArgument(signature, pos);
        }
        return pos + 1;
    }

    private static int checkTypeArgument(String signature, int pos) {
        char c = CheckMethodAdapter.getChar(signature, pos);
        if (c == '*') {
            return pos + 1;
        }
        if (c == '+' || c == '-') {
            ++pos;
        }
        return CheckMethodAdapter.checkFieldTypeSignature(signature, pos);
    }

    private static int checkTypeVariableSignature(String signature, int pos) {
        pos = CheckMethodAdapter.checkChar('T', signature, pos);
        pos = CheckMethodAdapter.checkIdentifier(signature, pos);
        return CheckMethodAdapter.checkChar(';', signature, pos);
    }

    private static int checkTypeSignature(String signature, int pos) {
        switch (CheckMethodAdapter.getChar(signature, pos)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos + 1;
            }
        }
        return CheckMethodAdapter.checkFieldTypeSignature(signature, pos);
    }

    private static int checkIdentifier(String signature, int pos) {
        if (!Character.isJavaIdentifierStart(CheckMethodAdapter.getChar(signature, pos))) {
            throw new IllegalArgumentException(signature + ": identifier expected at index " + pos);
        }
        ++pos;
        while (Character.isJavaIdentifierPart(CheckMethodAdapter.getChar(signature, pos))) {
            ++pos;
        }
        return pos;
    }

    private static int checkChar(char c, String signature, int pos) {
        if (CheckMethodAdapter.getChar(signature, pos) == c) {
            return pos + 1;
        }
        throw new IllegalArgumentException(signature + ": '" + c + "' expected at index " + pos);
    }

    private static char getChar(String signature, int pos) {
        return pos < signature.length() ? signature.charAt(pos) : (char)'\u0000';
    }

    void checkLabel(Label label, boolean checkVisited, String msg) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null)");
        }
        if (checkVisited && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field f = CheckMethodAdapter.getLabelStatusField();
        int status = 0;
        try {
            status = f == null ? 0 : (Integer)f.get(label);
        }
        catch (IllegalAccessException e) {
            throw new Error("Internal error");
        }
        if ((status & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String name2) {
        try {
            Field f = Label.class.getDeclaredField(name2);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static {
        String s = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGGECEBBEEBBAMHHAA";
        TYPE = new int[s.length()];
        for (int i = 0; i < TYPE.length; ++i) {
            CheckMethodAdapter.TYPE[i] = s.charAt(i) - 65 - 1;
        }
    }
}

