/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map<String, Object> beans = new HashMap<String, Object>();

    public void addBean(String name2, Object bean) {
        this.beans.put(name2, bean);
    }

    @Override
    public Object getBean(String name2) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name2) && !(bean instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean.getClass());
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        return bean;
    }

    @Override
    public <T> T getBean(String name2, Class<T> requiredType) throws BeansException {
        Object bean = this.getBean(name2);
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name2, requiredType, bean.getClass());
        }
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length > 1) {
            throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Override
    public Object getBean(String name2, Object ... args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments)");
        }
        return this.getBean(name2);
    }

    @Override
    public boolean containsBean(String name2) {
        return this.beans.containsKey(name2);
    }

    @Override
    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name2);
        return bean instanceof FactoryBean && ((FactoryBean)bean).isSingleton();
    }

    @Override
    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name2);
        return bean instanceof SmartFactoryBean && ((SmartFactoryBean)bean).isPrototype() || bean instanceof FactoryBean && !((FactoryBean)bean).isSingleton();
    }

    @Override
    public boolean isTypeMatch(String name2, Class<?> targetType) throws NoSuchBeanDefinitionException {
        Class<?> type = this.getType(name2);
        return targetType == null || type != null && targetType.isAssignableFrom(type);
    }

    @Override
    public Class<?> getType(String name2) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            return ((FactoryBean)bean).getObjectType();
        }
        return bean.getClass();
    }

    @Override
    public String[] getAliases(String name2) {
        return new String[0];
    }

    @Override
    public boolean containsBeanDefinition(String name2) {
        return this.beans.containsKey(name2);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean includeFactoryBeans) {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        ArrayList<String> matches = new ArrayList<String>();
        for (String name2 : this.beans.keySet()) {
            Object beanInstance = this.beans.get(name2);
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Class<?> objectType;
                if (!includeFactoryBeans || (objectType = ((FactoryBean)beanInstance).getObjectType()) == null || type != null && !type.isAssignableFrom(objectType)) continue;
                matches.add(name2);
                continue;
            }
            if (type != null && !type.isInstance(beanInstance)) continue;
            matches.add(name2);
        }
        return StringUtils.toStringArray(matches);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean includeFactoryBeans) throws BeansException {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        HashMap<String, Object> matches = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            String beanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                if (!includeFactoryBeans) continue;
                FactoryBean factory = (FactoryBean)beanInstance;
                Class<?> objectType = factory.getObjectType();
                if (!includeNonSingletons && !factory.isSingleton() || objectType == null || type != null && !type.isAssignableFrom(objectType)) continue;
                matches.put(beanName, this.getBean(beanName, type));
                continue;
            }
            if (type != null && !type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }

    @Override
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> results = new ArrayList<String>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return AnnotationUtils.findAnnotation(this.getType(beanName), annotationType);
    }
}

