/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;

public class ConcurrentMapCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private boolean dynamic = true;
    private boolean allowNullValues = true;

    public ConcurrentMapCacheManager() {
    }

    public ConcurrentMapCacheManager(String ... cacheNames) {
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    public void setCacheNames(Collection<String> cacheNames) {
        if (cacheNames != null) {
            for (String name2 : cacheNames) {
                this.cacheMap.put(name2, this.createConcurrentMapCache(name2));
            }
            this.dynamic = false;
        }
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name2) {
        Cache cache = (Cache)this.cacheMap.get(name2);
        if (cache == null && this.dynamic) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(name2);
                if (cache == null) {
                    cache = this.createConcurrentMapCache(name2);
                    this.cacheMap.put(name2, cache);
                }
            }
        }
        return cache;
    }

    protected Cache createConcurrentMapCache(String name2) {
        return new ConcurrentMapCache(name2, this.isAllowNullValues());
    }
}

