/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.cache.config.AnnotationDrivenCacheBeanDefinitionParser;
import org.springframework.cache.config.CacheAdviceParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CacheNamespaceHandler
extends NamespaceHandlerSupport {
    static final String CACHE_MANAGER_ATTRIBUTE = "cache-manager";
    static final String DEFAULT_CACHE_MANAGER_BEAN_NAME = "cacheManager";

    static String extractCacheManager(Element element) {
        return element.hasAttribute(CACHE_MANAGER_ATTRIBUTE) ? element.getAttribute(CACHE_MANAGER_ATTRIBUTE) : DEFAULT_CACHE_MANAGER_BEAN_NAME;
    }

    static BeanDefinition parseKeyGenerator(Element element, BeanDefinition def) {
        String name2 = element.getAttribute("key-generator");
        if (StringUtils.hasText(name2)) {
            def.getPropertyValues().add("keyGenerator", new RuntimeBeanReference(name2.trim()));
        }
        return def;
    }

    @Override
    public void init() {
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenCacheBeanDefinitionParser());
        this.registerBeanDefinitionParser("advice", new CacheAdviceParser());
    }
}

