/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class BeanExpressionContextAccessor
implements PropertyAccessor {
    @Override
    public boolean canRead(EvaluationContext context, Object target, String name2) throws AccessException {
        return ((BeanExpressionContext)target).containsObject(name2);
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name2) throws AccessException {
        return new TypedValue(((BeanExpressionContext)target).getObject(name2));
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name2) throws AccessException {
        return false;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name2, Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanExpressionContext.class};
    }
}

