/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.NumberUtils;

public class OpModulus
extends Operator {
    public OpModulus(int pos, SpelNodeImpl ... operands) {
        super("%", pos, operands);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object leftOperand = this.getLeftOperand().getValueInternal(state).getValue();
        Object rightOperand = this.getRightOperand().getValueInternal(state).getValue();
        if (leftOperand instanceof Number && rightOperand instanceof Number) {
            Number leftNumber = (Number)leftOperand;
            Number rightNumber = (Number)rightOperand;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = NumberUtils.convertNumberToTargetClass(leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = NumberUtils.convertNumberToTargetClass(rightNumber, BigDecimal.class);
                return new TypedValue(leftBigDecimal.remainder(rightBigDecimal));
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return new TypedValue(leftNumber.doubleValue() % rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return new TypedValue(Float.valueOf(leftNumber.floatValue() % rightNumber.floatValue()));
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return new TypedValue(leftNumber.longValue() % rightNumber.longValue());
            }
            return new TypedValue(leftNumber.intValue() % rightNumber.intValue());
        }
        return state.operate(Operation.MODULUS, leftOperand, rightOperand);
    }
}

