/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

public class PropertyOrFieldReference
extends SpelNodeImpl {
    private final boolean nullSafe;
    private final String name;
    private volatile PropertyAccessor cachedReadAccessor;
    private volatile PropertyAccessor cachedWriteAccessor;

    public PropertyOrFieldReference(boolean nullSafe, String propertyOrFieldName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.nullSafe = nullSafe;
        this.name = propertyOrFieldName;
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        return new AccessorLValue(this, state.getActiveContextObject(), state.getEvaluationContext(), state.getConfiguration().isAutoGrowNullReferences());
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueInternal(state.getActiveContextObject(), state.getEvaluationContext(), state.getConfiguration().isAutoGrowNullReferences());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypedValue getValueInternal(TypedValue contextObject, EvaluationContext eContext, boolean isAutoGrowNullReferences) throws EvaluationException {
        TypedValue result = this.readProperty(contextObject, eContext, this.name);
        if (result.getValue() != null) return result;
        if (!isAutoGrowNullReferences) return result;
        if (!this.nextChildIs(Indexer.class, PropertyOrFieldReference.class)) return result;
        TypeDescriptor resultDescriptor = result.getTypeDescriptor();
        if (resultDescriptor.getType().equals(List.class) || resultDescriptor.getType().equals(Map.class)) {
            if (resultDescriptor.getType().equals(List.class)) {
                try {
                    if (!this.isWritableProperty(this.name, contextObject, eContext)) return result;
                    List newList = (List)ArrayList.class.newInstance();
                    this.writeProperty(contextObject, eContext, this.name, newList);
                    return this.readProperty(contextObject, eContext, this.name);
                }
                catch (InstantiationException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
            }
            try {
                if (!this.isWritableProperty(this.name, contextObject, eContext)) return result;
                Map newMap = (Map)HashMap.class.newInstance();
                this.writeProperty(contextObject, eContext, this.name, newMap);
                return this.readProperty(contextObject, eContext, this.name);
            }
            catch (InstantiationException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
        }
        try {
            if (!this.isWritableProperty(this.name, contextObject, eContext)) return result;
            Object newObject = result.getTypeDescriptor().getType().newInstance();
            this.writeProperty(contextObject, eContext, this.name, newObject);
            return this.readProperty(contextObject, eContext, this.name);
        }
        catch (InstantiationException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result.getTypeDescriptor().getType());
        }
        catch (IllegalAccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result.getTypeDescriptor().getType());
        }
    }

    @Override
    public void setValue(ExpressionState state, Object newValue) throws SpelEvaluationException {
        this.writeProperty(state.getActiveContextObject(), state.getEvaluationContext(), this.name, newValue);
    }

    @Override
    public boolean isWritable(ExpressionState state) throws SpelEvaluationException {
        return this.isWritableProperty(this.name, state.getActiveContextObject(), state.getEvaluationContext());
    }

    @Override
    public String toStringAST() {
        return this.name;
    }

    private TypedValue readProperty(TypedValue contextObject, EvaluationContext eContext, String name2) throws EvaluationException {
        List<PropertyAccessor> accessorsToTry;
        Object targetObject = contextObject.getValue();
        if (targetObject == null && this.nullSafe) {
            return TypedValue.NULL;
        }
        PropertyAccessor accessorToUse = this.cachedReadAccessor;
        if (accessorToUse != null) {
            try {
                return accessorToUse.read(eContext, contextObject.getValue(), name2);
            }
            catch (AccessException ae) {
                this.cachedReadAccessor = null;
            }
        }
        if ((accessorsToTry = this.getPropertyAccessorsToTry(contextObject.getValue(), eContext.getPropertyAccessors())) != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canRead(eContext, contextObject.getValue(), name2)) continue;
                    if (accessor instanceof ReflectivePropertyAccessor) {
                        accessor = ((ReflectivePropertyAccessor)accessor).createOptimalAccessor(eContext, contextObject.getValue(), name2);
                    }
                    this.cachedReadAccessor = accessor;
                    return accessor.read(eContext, contextObject.getValue(), name2);
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(ae, SpelMessage.EXCEPTION_DURING_PROPERTY_READ, name2, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE_ON_NULL, name2);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE, name2, FormatHelper.formatClassNameForMessage(this.getObjectClass(contextObject.getValue())));
    }

    private void writeProperty(TypedValue contextObject, EvaluationContext eContext, String name2, Object newValue) throws SpelEvaluationException {
        List<PropertyAccessor> accessorsToTry;
        if (contextObject.getValue() == null && this.nullSafe) {
            return;
        }
        PropertyAccessor accessorToUse = this.cachedWriteAccessor;
        if (accessorToUse != null) {
            try {
                accessorToUse.write(eContext, contextObject.getValue(), name2, newValue);
                return;
            }
            catch (AccessException ae) {
                this.cachedWriteAccessor = null;
            }
        }
        if ((accessorsToTry = this.getPropertyAccessorsToTry(contextObject.getValue(), eContext.getPropertyAccessors())) != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canWrite(eContext, contextObject.getValue(), name2)) continue;
                    this.cachedWriteAccessor = accessor;
                    accessor.write(eContext, contextObject.getValue(), name2, newValue);
                    return;
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, name2, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE_ON_NULL, name2);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE, name2, FormatHelper.formatClassNameForMessage(this.getObjectClass(contextObject.getValue())));
    }

    public boolean isWritableProperty(String name2, TypedValue contextObject, EvaluationContext eContext) throws SpelEvaluationException {
        List<PropertyAccessor> accessorsToTry = this.getPropertyAccessorsToTry(contextObject.getValue(), eContext.getPropertyAccessors());
        if (accessorsToTry != null) {
            for (PropertyAccessor accessor : accessorsToTry) {
                try {
                    if (!accessor.canWrite(eContext, contextObject.getValue(), name2)) continue;
                    return true;
                }
                catch (AccessException ae) {
                }
            }
        }
        return false;
    }

    private List<PropertyAccessor> getPropertyAccessorsToTry(Object contextObject, List<PropertyAccessor> propertyAccessors) {
        Class<?> targetType = contextObject != null ? contextObject.getClass() : null;
        ArrayList<PropertyAccessor> specificAccessors = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> generalAccessors = new ArrayList<PropertyAccessor>();
        block0: for (PropertyAccessor resolver : propertyAccessors) {
            Class<?>[] targets = resolver.getSpecificTargetClasses();
            if (targets == null) {
                generalAccessors.add(resolver);
                continue;
            }
            if (targetType == null) continue;
            for (Class<?> clazz : targets) {
                if (clazz == targetType) {
                    specificAccessors.add(resolver);
                    continue block0;
                }
                if (!clazz.isAssignableFrom(targetType)) continue;
                generalAccessors.add(resolver);
            }
        }
        ArrayList<PropertyAccessor> resolvers = new ArrayList<PropertyAccessor>();
        resolvers.addAll(specificAccessors);
        generalAccessors.removeAll(specificAccessors);
        resolvers.addAll(generalAccessors);
        return resolvers;
    }

    private static class AccessorLValue
    implements ValueRef {
        private final PropertyOrFieldReference ref;
        private final TypedValue contextObject;
        private final EvaluationContext eContext;
        private final boolean autoGrowNullReferences;

        public AccessorLValue(PropertyOrFieldReference propertyOrFieldReference, TypedValue activeContextObject, EvaluationContext evaluationContext, boolean autoGrowNullReferences) {
            this.ref = propertyOrFieldReference;
            this.contextObject = activeContextObject;
            this.eContext = evaluationContext;
            this.autoGrowNullReferences = autoGrowNullReferences;
        }

        @Override
        public TypedValue getValue() {
            return this.ref.getValueInternal(this.contextObject, this.eContext, this.autoGrowNullReferences);
        }

        @Override
        public void setValue(Object newValue) {
            this.ref.writeProperty(this.contextObject, this.eContext, this.ref.name, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

