/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    @Override
    public ValueRef getValueRef(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return new ValueRef.TypedValueHolderValueRef(state.getActiveContextObject(), this);
        }
        if (this.name.equals(ROOT)) {
            return new ValueRef.TypedValueHolderValueRef(state.getRootContextObject(), this);
        }
        TypedValue result = state.lookupVariable(this.name);
        return new VariableRef(this.name, result, state.getEvaluationContext());
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return state.getActiveContextObject();
        }
        if (this.name.equals(ROOT)) {
            return state.getRootContextObject();
        }
        TypedValue result = state.lookupVariable(this.name);
        return result;
    }

    @Override
    public void setValue(ExpressionState state, Object value) throws SpelEvaluationException {
        state.setVariable(this.name, value);
    }

    @Override
    public String toStringAST() {
        return "#" + this.name;
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !this.name.equals(THIS) && !this.name.equals(ROOT);
    }

    class VariableRef
    implements ValueRef {
        private final String name;
        private final TypedValue value;
        private final EvaluationContext evaluationContext;

        public VariableRef(String name2, TypedValue value, EvaluationContext evaluationContext) {
            this.name = name2;
            this.value = value;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TypedValue getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object newValue) {
            this.evaluationContext.setVariable(this.name, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

