/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.PrintStream;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import org.apache.tools.ant.BuildException;

public class GenerateChangeLogTask
extends BaseLiquibaseTask {
    private String diffTypes;
    private String dataDir;
    private boolean includeCatalog;
    private boolean includeSchema;
    private boolean includeTablespace;

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public void setDiffTypes(String diffTypes) {
        this.diffTypes = diffTypes;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public boolean getIncludeCatalog() {
        return this.includeCatalog;
    }

    public void setIncludeCatalog(boolean includeCatalog) {
        this.includeCatalog = includeCatalog;
    }

    public boolean getIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean getIncludeTablespace() {
        return this.includeTablespace;
    }

    public void setIncludeTablespace(boolean includeTablespace) {
        this.includeTablespace = includeTablespace;
    }

    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        Liquibase liquibase = null;
        try {
            PrintStream writer = this.createPrintStream();
            if (writer == null) {
                throw new BuildException("generateChangeLog requires outputFile to be set");
            }
            liquibase = this.createLiquibase();
            Database database = liquibase.getDatabase();
            SnapshotControl snapshotControl = new SnapshotControl(database, this.getDiffTypes());
            DatabaseSnapshot referenceSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName()), database, snapshotControl);
            DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(referenceSnapshot, null, new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName()), new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName()))}, this.getDiffTypes()));
            DiffOutputControl diffOutputConfig = new DiffOutputControl(this.getIncludeCatalog(), this.getIncludeSchema(), this.getIncludeTablespace());
            diffOutputConfig.setDataDir(this.getDataDir());
            if (this.getChangeLogFile() == null) {
                new DiffToChangeLog(diffResult, diffOutputConfig).print(writer);
            } else {
                new DiffToChangeLog(diffResult, diffOutputConfig).print(this.getChangeLogFile());
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        this.closeDatabase(liquibase);
    }
}

