/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_PSET
extends FsInode {
    private static final String SIZE = "size";
    private static final String IO = "io";
    private static final String ONLN = "bringonline";
    private static final String STG = "stage";
    private static final String PIN = "pin";
    private final String[] _args;

    public FsInode_PSET(FileSystemProvider fs, String id, String[] args) {
        super(fs, id, FsInodeType.PSET);
        this._args = (String[])args.clone();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    @Override
    public void setStat(Stat newStat) {
        block16: {
            try {
                if (!newStat.isDefined(Stat.StatAttributes.MTIME)) break block16;
                switch (this._args[0]) {
                    case "size": {
                        Stat s = new Stat();
                        try {
                            s.setSize(Long.parseLong(this._args[1]));
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                        s.setMTime(newStat.getMTime());
                        this._fs.setInodeAttributes(this, 0, s);
                        break;
                    }
                    case "io": {
                        this._fs.setInodeIo(this, this._args[1].equals("on"));
                        break;
                    }
                    case "bringonline": 
                    case "stage": 
                    case "pin": {
                        this.handlePinRequest();
                        break;
                    }
                }
            }
            catch (ChimeraFsException chimeraFsException) {
                // empty catch block
            }
        }
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        ret.setSize(0L);
        if (this._args[0].equals(IO)) {
            ret.setUid(0);
            ret.setGid(0);
        }
        return ret;
    }

    @Override
    public byte[] getIdentifier() {
        StringBuilder sb = new StringBuilder();
        for (String arg : this._args) {
            sb.append(arg).append(':');
        }
        return this.byteBase(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsInode_PSET)) {
            return false;
        }
        return super.equals(o) && Arrays.equals(this._args, ((FsInode_PSET)o)._args);
    }

    @Override
    public int hashCode() {
        return 17;
    }

    private void handlePinRequest() throws ChimeraFsException {
    }
}

