/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import java.io.IOException;
import org.dcache.auth.Subjects;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class ExportPathCreator {
    private ExportFile exportFile;
    private VirtualFileSystem vfs;

    public void setVfs(VirtualFileSystem vfs) {
        this.vfs = vfs;
    }

    public void setExportFile(ExportFile exportFile) {
        this.exportFile = exportFile;
    }

    public void init() throws IOException {
        Inode root = this.vfs.getRootInode();
        for (FsExport export : this.exportFile.getExports()) {
            String path = export.getPath();
            Splitter splitter = Splitter.on('/').omitEmptyStrings();
            Inode inode = root;
            for (String s : splitter.split(path)) {
                try {
                    Inode child = this.vfs.lookup(inode, s);
                }
                catch (NoEntException e) {
                    Inode inode2 = this.vfs.create(inode, Stat.Type.DIRECTORY, s, Subjects.ROOT, 511);
                }
            }
        }
    }
}

