/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.xdr.OPEN_CONFIRM4res;
import org.dcache.nfs.v4.xdr.OPEN_CONFIRM4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN_CONFIRM
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN_CONFIRM.class);

    OperationOPEN_CONFIRM(nfs_argop4 args) {
        super(args, 20);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        OPEN_CONFIRM4res res = result.opopen_confirm;
        Inode inode = context.currentInode();
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() == Stat.Type.DIRECTORY) {
            throw new IsDirException();
        }
        if (stat.type() == Stat.Type.SYMLINK) {
            throw new InvalException();
        }
        stateid4 stateid = this._args.opopen_confirm.open_stateid;
        _log.debug("confirmed stateID: {}", (Object)stateid);
        NFS4Client client = context.getStateHandler().getClientIdByStateId(stateid);
        client.validateSequence(this._args.opopen_confirm.seqid);
        NFS4State state = client.state(stateid);
        state.bumpSeqid();
        state.confirm();
        res.resok4 = new OPEN_CONFIRM4resok();
        res.resok4.open_stateid = state.stateid();
        res.status = 0;
    }
}

