/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.OperationPUTFH;
import org.dcache.nfs.v4.xdr.SETCLIENTID_CONFIRM4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETCLIENTID_CONFIRM
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationPUTFH.class);

    OperationSETCLIENTID_CONFIRM(nfs_argop4 args) {
        super(args, 36);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        SETCLIENTID_CONFIRM4res res = result.opsetclientid_confirm;
        Long clientid = this._args.opsetclientid_confirm.clientid.value;
        NFS4Client client = context.getStateHandler().getClientByID(clientid);
        if (client == null) {
            throw new StaleClientidException();
        }
        res.status = 22;
        if (client.verifierEquals(this._args.opsetclientid_confirm.setclientid_confirm)) {
            res.status = 0;
            client.setConfirmed();
        }
    }
}

