/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.util.List;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.RetryUncacheRepException;
import org.dcache.nfs.status.SeqMisorderedException;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSlot {
    private static final Logger _log = LoggerFactory.getLogger(SessionSlot.class);
    private int _sequence;
    private List<nfs_resop4> _reply;

    SessionSlot(int sequence) {
        this._sequence = sequence;
    }

    public SessionSlot() {
        this(0);
    }

    List<nfs_resop4> checkSlotSequence(int sequence, boolean checkCache) throws ChimeraNFSException {
        if (sequence == this._sequence) {
            _log.info("retransmit detected");
            if (this._reply != null) {
                return this._reply;
            }
            if (checkCache) {
                throw new RetryUncacheRepException();
            }
            return null;
        }
        int validValue = this._sequence + 1;
        if (sequence != validValue) {
            throw new SeqMisorderedException("disordered : v/n : " + Integer.toHexString(validValue) + "/" + Integer.toHexString(sequence));
        }
        this._sequence = sequence;
        this._reply = null;
        return null;
    }

    void update(List<nfs_resop4> reply) {
        this._reply = reply;
    }
}

