/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.nfs.vfs.ForwardingFileSystem;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VfsCacheConfig;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.utils.GuavaCacheMXBeanImpl;
import org.dcache.utils.Opaque;

public class VfsCache
extends ForwardingFileSystem {
    private final LoadingCache<CacheKey, Inode> _lookupCache;
    private final Cache<Opaque, Stat> _statCache;
    private final LoadingCache<Inode, Inode> _parentCache;
    private final Supplier<FsStat> _fsStatSupplier;
    private final VirtualFileSystem _inner;

    public VfsCache(VirtualFileSystem inner, VfsCacheConfig cacheConfig) {
        this._inner = inner;
        this._lookupCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().recordStats().build(new LoockupLoader());
        this._statCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().recordStats().build();
        this._parentCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(100L, TimeUnit.MILLISECONDS).softValues().recordStats().build(new ParentLoader());
        this._fsStatSupplier = cacheConfig.getFsStatLifeTime() > 0L ? Suppliers.memoizeWithExpiration(new FsStatSupplier(), cacheConfig.getFsStatLifeTime(), cacheConfig.getFsSataTimeUnit()) : new FsStatSupplier();
        new GuavaCacheMXBeanImpl("vfs-stat", this._statCache);
        new GuavaCacheMXBeanImpl("vfs-parent", this._parentCache);
        new GuavaCacheMXBeanImpl("vfs-lookup", this._lookupCache);
    }

    @Override
    protected VirtualFileSystem delegate() {
        return this._inner;
    }

    @Override
    public void commit(Inode inode, long offset, int count) throws IOException {
        this.invalidateStatCache(inode);
        this._inner.commit(inode, offset, count);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.symlink(parent, path, link, subject, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        Inode inode = this.lookup(parent, path);
        this._inner.remove(parent, path);
        this.invalidateLookupCache(parent, path);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this.parentFromCacheOrLoad(inode);
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        boolean isChanged = this._inner.move(src, oldName, dest, newName);
        if (isChanged) {
            this.invalidateLookupCache(src, oldName);
            this.invalidateLookupCache(dest, newName);
            this.invalidateStatCache(src);
            this.invalidateStatCache(dest);
        }
        return isChanged;
    }

    @Override
    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.mkdir(parent, path, subject, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        Inode inode = this._inner.link(parent, link, path, subject);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
        return inode;
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        return this.lookupFromCacheOrLoad(parent, path);
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this._fsStatSupplier.get();
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.create(parent, type, path, subject, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        this.updateParentCache(inode, parent);
        return inode;
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this.statFromCacheOrLoad(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this._inner.setattr(inode, stat);
        this.invalidateStatCache(inode);
    }

    public void invalidateLookupCache(Inode parent, String path) {
        this._lookupCache.invalidate(new CacheKey(parent, path));
    }

    private void updateLookupCache(Inode parent, String path, Inode inode) {
        this._lookupCache.put(new CacheKey(parent, path), inode);
    }

    public void invalidateStatCache(Inode inode) {
        this._statCache.invalidate(new Opaque(inode.getFileId()));
    }

    private void updateParentCache(Inode inode, Inode parent) {
        this._parentCache.put(inode, parent);
    }

    private Inode lookupFromCacheOrLoad(Inode parent, String path) throws IOException {
        try {
            return this._lookupCache.get(new CacheKey(parent, path));
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf(t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    private Stat statFromCacheOrLoad(final Inode inode) throws IOException {
        try {
            return this._statCache.get(new Opaque(inode.getFileId()), new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    return VfsCache.this._inner.getattr(inode);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf(t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    private Inode parentFromCacheOrLoad(Inode inode) throws IOException {
        try {
            return this._parentCache.get(inode);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf(t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    private class FsStatSupplier
    implements Supplier<FsStat> {
        private FsStatSupplier() {
        }

        @Override
        public FsStat get() {
            try {
                return VfsCache.this._inner.getFsStat();
            }
            catch (IOException e) {
                return new FsStat(0L, 0L, 0L, 0L);
            }
        }
    }

    private static class CacheKey {
        private final Inode _parent;
        private final String _name;

        public CacheKey(Inode parent, String name2) {
            this._parent = parent;
            this._name = name2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return other._parent.equals(this._parent) & other._name.equals(this._name);
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._parent.hashCode();
        }

        public String getName() {
            return this._name;
        }

        public Inode getParent() {
            return this._parent;
        }
    }

    private class ParentLoader
    extends CacheLoader<Inode, Inode> {
        private ParentLoader() {
        }

        @Override
        public Inode load(Inode inode) throws Exception {
            return VfsCache.this._inner.parentOf(inode);
        }
    }

    private class LoockupLoader
    extends CacheLoader<CacheKey, Inode> {
        private LoockupLoader() {
        }

        @Override
        public Inode load(CacheKey k) throws Exception {
            return VfsCache.this._inner.lookup(k.getParent(), k.getName());
        }
    }
}

