/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import java.io.IOException;
import java.util.List;
import javax.security.auth.Subject;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;

public interface VirtualFileSystem {
    public int access(Inode var1, int var2) throws IOException;

    public Inode create(Inode var1, Stat.Type var2, String var3, Subject var4, int var5) throws IOException;

    public FsStat getFsStat() throws IOException;

    public Inode getRootInode() throws IOException;

    public Inode lookup(Inode var1, String var2) throws IOException;

    public Inode link(Inode var1, Inode var2, String var3, Subject var4) throws IOException;

    public List<DirectoryEntry> list(Inode var1) throws IOException;

    public Inode mkdir(Inode var1, String var2, Subject var3, int var4) throws IOException;

    public boolean move(Inode var1, String var2, Inode var3, String var4) throws IOException;

    public Inode parentOf(Inode var1) throws IOException;

    public int read(Inode var1, byte[] var2, long var3, int var5) throws IOException;

    public String readlink(Inode var1) throws IOException;

    public void remove(Inode var1, String var2) throws IOException;

    public Inode symlink(Inode var1, String var2, String var3, Subject var4, int var5) throws IOException;

    public WriteResult write(Inode var1, byte[] var2, long var3, int var5, StabilityLevel var6) throws IOException;

    public void commit(Inode var1, long var2, int var4) throws IOException;

    public Stat getattr(Inode var1) throws IOException;

    public void setattr(Inode var1, Stat var2) throws IOException;

    public nfsace4[] getAcl(Inode var1) throws IOException;

    public void setAcl(Inode var1, nfsace4[] var2) throws IOException;

    public boolean hasIOLayout(Inode var1) throws IOException;

    public AclCheckable getAclCheckable();

    public NfsIdMapping getIdMapper();

    public static enum StabilityLevel {
        UNSTABLE,
        DATA_SYNC,
        FILE_SYNC;


        public static StabilityLevel fromStableHow(int stableHowValue) {
            switch (stableHowValue) {
                case 0: {
                    return UNSTABLE;
                }
                case 1: {
                    return DATA_SYNC;
                }
                case 2: {
                    return FILE_SYNC;
                }
            }
            throw new IllegalArgumentException("unhandled stability value " + stableHowValue);
        }

        public int toStableHow() {
            return this.ordinal();
        }
    }

    public static class WriteResult {
        private final int bytesWritten;
        private final StabilityLevel stabilityLevel;

        public WriteResult(StabilityLevel stabilityLevel, int bytesWritten) {
            this.stabilityLevel = stabilityLevel;
            this.bytesWritten = bytesWritten;
        }

        public int getBytesWritten() {
            return this.bytesWritten;
        }

        public StabilityLevel getStabilityLevel() {
            return this.stabilityLevel;
        }
    }
}

