/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.core.convert.TypeDescriptor;

public class FormatHelper {
    public static String formatMethodForMessage(String name2, List<TypeDescriptor> argumentTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name2);
        sb.append("(");
        for (int i = 0; i < argumentTypes.size(); ++i) {
            TypeDescriptor typeDescriptor;
            if (i > 0) {
                sb.append(",");
            }
            if ((typeDescriptor = argumentTypes.get(i)) != null) {
                sb.append(FormatHelper.formatClassNameForMessage(typeDescriptor.getType()));
                continue;
            }
            sb.append(FormatHelper.formatClassNameForMessage(null));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatClassNameForMessage(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        StringBuilder fmtd = new StringBuilder();
        if (clazz.isArray()) {
            int dims = 1;
            Class<?> baseClass = clazz.getComponentType();
            while (baseClass.isArray()) {
                baseClass = baseClass.getComponentType();
                ++dims;
            }
            fmtd.append(baseClass.getName());
            for (int i = 0; i < dims; ++i) {
                fmtd.append("[]");
            }
        } else {
            fmtd.append(clazz.getName());
        }
        return fmtd.toString();
    }
}

