/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.util.ISODateFormat;

@DatabaseChange(name="addDefaultValue", description="Adds a default value to the database definition for the specified column.\nOne of defaultValue, defaultValueNumeric, defaultValueBoolean or defaultValueDate must be set", priority=1, appliesTo={"column"})
public class AddDefaultValueChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;
    private String defaultValue;
    private String defaultValueNumeric;
    private String defaultValueDate;
    private Boolean defaultValueBoolean;
    private DatabaseFunction defaultValueComputed;
    private SequenceNextValueFunction defaultValueSequenceNext;

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table to containing the column", exampleValue="file")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column", description="Name of the column to add a default value to", exampleValue="fileName")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @DatabaseChangeProperty(description="Current data type of the column to add default value to", exampleValue="int")
    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    @DatabaseChangeProperty(description="Default value. Either this property or one of the other defaultValue* properties are required.", exampleValue="Something Else", requiredForDatabase={"none"})
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public String getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(String defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public String getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public DatabaseFunction getDefaultValueComputed() {
        return this.defaultValueComputed;
    }

    public void setDefaultValueComputed(DatabaseFunction defaultValueComputed) {
        this.defaultValueComputed = defaultValueComputed;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public SequenceNextValueFunction getDefaultValueSequenceNext() {
        return this.defaultValueSequenceNext;
    }

    public void setDefaultValueSequenceNext(SequenceNextValueFunction defaultValueSequenceNext) {
        this.defaultValueSequenceNext = defaultValueSequenceNext;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        Object defaultValue = null;
        if (this.getDefaultValue() != null) {
            defaultValue = this.getDefaultValue();
        } else if (this.getDefaultValueBoolean() != null) {
            defaultValue = this.getDefaultValueBoolean();
        } else if (this.getDefaultValueNumeric() != null) {
            try {
                defaultValue = NumberFormat.getInstance(Locale.US).parse(this.getDefaultValueNumeric());
            }
            catch (ParseException e) {
                defaultValue = new DatabaseFunction(this.getDefaultValueNumeric());
            }
        } else if (this.getDefaultValueDate() != null) {
            try {
                defaultValue = new ISODateFormat().parse(this.getDefaultValueDate());
            }
            catch (ParseException e) {
                defaultValue = new DatabaseFunction(this.getDefaultValueDate());
            }
        } else if (this.getDefaultValueComputed() != null) {
            defaultValue = this.getDefaultValueComputed();
        } else if (this.getDefaultValueSequenceNext() != null) {
            defaultValue = this.getDefaultValueSequenceNext();
        }
        return new SqlStatement[]{new AddDefaultValueStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType(), defaultValue)};
    }

    @Override
    protected Change[] createInverses() {
        DropDefaultValueChange inverse = new DropDefaultValueChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setColumnName(this.getColumnName());
        inverse.setColumnDataType(this.getColumnDataType());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "Default value added to " + this.getTableName() + "." + this.getColumnName();
    }
}

