/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.dcache.acl.ACE;
import org.dcache.chimera.BackEndErrorHimeraFsException;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.FsInode_CONST;
import org.dcache.chimera.FsInode_ID;
import org.dcache.chimera.FsInode_NAMEOF;
import org.dcache.chimera.FsInode_PARENT;
import org.dcache.chimera.FsInode_PATHOF;
import org.dcache.chimera.FsInode_PGET;
import org.dcache.chimera.FsInode_PSET;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.FsInode_TAGS;
import org.dcache.chimera.FsSqlDriver;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.InodeId;
import org.dcache.chimera.InvalidArgumentChimeraException;
import org.dcache.chimera.InvalidNameChimeraException;
import org.dcache.chimera.IsDirChimeraException;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.PnfsCommandProcessor;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.AccessLatency;
import org.dcache.chimera.store.InodeStorageInformation;
import org.dcache.chimera.store.RetentionPolicy;
import org.dcache.chimera.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcFs
implements FileSystemProvider {
    private static final Logger _log = LoggerFactory.getLogger(JdbcFs.class);
    private static final int LEVELS_NUMBER = 7;
    private final FsInode _rootInode;
    private final String _wormID;
    private static final int MIN_HANDLE_LEN = 4;
    private final FsSqlDriver _sqlDriver;
    private final DataSource _dbConnectionsPool;
    private final Integer DUMMY_KEY = 0;
    private final Executor _fsStatUpdateExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("fsstat-updater-thread-%d").build());
    private final LoadingCache<Object, FsStat> _fsStatCache = CacheBuilder.newBuilder().refreshAfterWrite(100L, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading(new CacheLoader<Object, FsStat>(){

        @Override
        public FsStat load(Object k) throws Exception {
            return JdbcFs.this.getFsStat0();
        }
    }, this._fsStatUpdateExecutor));
    private final int _fsId;
    static final long AVAILABLE_SPACE = 0x1000000000000000L;
    static final long TOTAL_FILES = 0x3C00000L;
    private static final int MAX_NAME_LEN = 255;
    private static final byte[] FH_V0_BIN = new byte[]{48, 48, 48, 48};
    private static final byte[] FH_V0_REG = new byte[]{48, 58};
    private static final byte[] FH_V0_PFS = new byte[]{50, 53, 53, 58};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public JdbcFs(DataSource dataSource, String dialect) {
        this(dataSource, dialect, 0);
    }

    public JdbcFs(DataSource dataSource, String dialect, int id) {
        this._dbConnectionsPool = dataSource;
        this._fsId = id;
        this._sqlDriver = FsSqlDriver.getDriverInstance(dialect);
        this._rootInode = new FsInode(this, "000000000000000000000000000000000000");
        String wormID = null;
        try {
            wormID = this.getWormID().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._wormID = wormID;
    }

    private FsInode getWormID() throws ChimeraFsException {
        return this.path2inode("/admin/etc/config");
    }

    @Override
    public FsInode createLink(String src, String dest) throws ChimeraFsException {
        File file = new File(src);
        return this.createLink(this.path2inode(file.getParent()), file.getName(), dest);
    }

    @Override
    public FsInode createLink(FsInode parent, String name2, String dest) throws ChimeraFsException {
        return this.createLink(parent, name2, 0, 0, 420, dest.getBytes());
    }

    @Override
    public FsInode createLink(FsInode parent, String name2, int uid, int gid, int mode, byte[] dest) throws ChimeraFsException {
        FsInode inode;
        Connection dbConnection;
        JdbcFs.checkNameLength(name2);
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            if ((parent.statCache().getMode() & 0x400) != 0) {
                gid = parent.statCache().getGid();
            }
            inode = this._sqlDriver.createFile(dbConnection, parent, name2, uid, gid, mode, 40960);
            this._sqlDriver.setInodeIo(dbConnection, inode, true);
            this._sqlDriver.write(dbConnection, inode, 0, 0L, dest, 0, dest.length);
            dbConnection.commit();
        }
        catch (SQLException se) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isDuplicatedKeyError(se)) {
                throw new FileExistsChimeraFsException();
            }
            _log.error("createLink ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode createHLink(FsInode parent, FsInode inode, String name2) throws ChimeraFsException {
        Connection dbConnection;
        JdbcFs.checkNameLength(name2);
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.createEntryInParent(dbConnection, parent, name2, inode);
            this._sqlDriver.incNlink(dbConnection, inode);
            this._sqlDriver.incNlink(dbConnection, parent);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isDuplicatedKeyError(e)) {
                throw new FileExistsChimeraFsException();
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode createFile(String path) throws ChimeraFsException {
        File file = new File(path);
        return this.createFile(this.path2inode(file.getParent()), file.getName());
    }

    @Override
    public FsInode createFile(FsInode parent, String name2) throws ChimeraFsException {
        return this.createFile(parent, name2, 0, 0, 420);
    }

    @Override
    public FsInode createFileLevel(FsInode inode, int level) throws ChimeraFsException {
        return this.createFileLevel(inode, 0, 0, 420, level);
    }

    @Override
    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        return this.createFile(parent, name2, owner, group, mode, 32768);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode inode = null;
        try {
            if (name2.startsWith(".(")) {
                String[] cmd = PnfsCommandProcessor.process(name2);
                if (name2.startsWith(".(tag)(") && cmd.length == 2) {
                    this.createTag(parent, cmd[1], owner, group, 420);
                    FsInode_TAG fsInode_TAG = new FsInode_TAG((FileSystemProvider)this, parent.toString(), cmd[1]);
                    return fsInode_TAG;
                }
                if (name2.startsWith(".(pset)(") || name2.startsWith(".(fset)(")) {
                    throw new ChimeraFsException("Not supported");
                }
                if (name2.startsWith(".(use)(") && cmd.length == 3) {
                    FsInode useInode = this.inodeOf(parent, cmd[2]);
                    int level = Integer.parseInt(cmd[1]);
                    try {
                        dbConnection.setAutoCommit(false);
                        inode = this._sqlDriver.createLevel(dbConnection, useInode, useInode.stat().getUid(), useInode.stat().getGid(), useInode.stat().getMode(), level);
                        dbConnection.commit();
                    }
                    catch (SQLException se) {
                        SqlHelper.tryToRollback(dbConnection);
                        if (this._sqlDriver.isDuplicatedKeyError(se)) {
                            throw new FileExistsChimeraFsException(name2);
                        }
                        _log.error("create File: ", se);
                    }
                }
                if (name2.startsWith(".(access)(") && cmd.length == 3) {
                    FsInode accessInode = new FsInode(this, cmd[1]);
                    int accessLevel = Integer.parseInt(cmd[2]);
                    if (accessLevel == 0) {
                        inode = accessInode;
                    } else {
                        try {
                            dbConnection.setAutoCommit(false);
                            inode = this._sqlDriver.createLevel(dbConnection, accessInode, accessInode.stat().getUid(), accessInode.stat().getGid(), accessInode.stat().getMode(), accessLevel);
                            dbConnection.commit();
                        }
                        catch (SQLException se) {
                            SqlHelper.tryToRollback(dbConnection);
                            if (this._sqlDriver.isDuplicatedKeyError(se)) {
                                throw new FileExistsChimeraFsException(name2);
                            }
                            _log.error("create File: ", se);
                        }
                    }
                }
                FsInode fsInode = inode;
                return fsInode;
            }
            try {
                JdbcFs.checkNameLength(name2);
                dbConnection.setAutoCommit(false);
                Stat parentStat = this._sqlDriver.stat(dbConnection, parent);
                if (parentStat == null) {
                    throw new FileNotFoundHimeraFsException("parent=" + parent.toString());
                }
                if ((parentStat.getMode() & 0xF000) != 16384) {
                    throw new NotDirChimeraException(parent);
                }
                if ((parentStat.getMode() & 0x400) != 0) {
                    group = parent.statCache().getGid();
                }
                inode = this._sqlDriver.createFile(dbConnection, parent, name2, owner, group, mode, type);
                dbConnection.commit();
            }
            catch (SQLException se) {
                SqlHelper.tryToRollback(dbConnection);
                if (this._sqlDriver.isDuplicatedKeyError(se)) {
                    throw new FileExistsChimeraFsException();
                }
                _log.error("create File: ", se);
                throw new IOHimeraFsException(se.getMessage());
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public void createFileWithId(FsInode parent, FsInode inode, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        block11: {
            Connection dbConnection;
            JdbcFs.checkNameLength(name2);
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            try {
                if (!parent.exists()) {
                    throw new FileNotFoundHimeraFsException("parent=" + parent.toString());
                }
                if (parent.isDirectory()) {
                    dbConnection.setAutoCommit(false);
                    if ((parent.statCache().getMode() & 0x400) != 0) {
                        group = parent.statCache().getGid();
                    }
                    inode = this._sqlDriver.createFileWithId(dbConnection, parent, inode, name2, owner, group, mode, type);
                    dbConnection.commit();
                    break block11;
                }
                throw new NotDirChimeraException(parent);
            }
            catch (SQLException se) {
                SqlHelper.tryToRollback(dbConnection);
                if (this._sqlDriver.isDuplicatedKeyError(se)) {
                    throw new FileExistsChimeraFsException();
                }
                _log.error("create File: ", se);
                throw new IOHimeraFsException(se.getMessage());
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
    }

    FsInode createFileLevel(FsInode inode, int owner, int group, int mode, int level) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode levelInode = null;
        try {
            dbConnection.setAutoCommit(false);
            levelInode = this._sqlDriver.createLevel(dbConnection, inode, owner, group, mode | 0x8000, level);
            dbConnection.commit();
        }
        catch (SQLException se) {
            _log.error("create level: ", se);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return levelInode;
    }

    public String[] listDir(String dir) {
        String[] list = null;
        try {
            list = this.listDir(this.path2inode(dir));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public String[] listDir(FsInode dir) throws IOHimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String[] list = null;
        try {
            dbConnection.setAutoCommit(true);
            list = this._sqlDriver.listDir(dbConnection, dir);
        }
        catch (SQLException se) {
            _log.error("list: ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return list;
    }

    @Override
    public DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream(FsInode dir) throws IOHimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            return this._sqlDriver.newDirectoryStream(dbConnection, dir);
        }
        catch (SQLException se) {
            _log.error("list full: ", se);
            SqlHelper.tryToClose(dbConnection);
            throw new IOHimeraFsException(se.getMessage());
        }
    }

    @Override
    public void remove(String path) throws ChimeraFsException {
        File filePath = new File(path);
        String parentPath = filePath.getParent();
        if (parentPath == null) {
            throw new ChimeraFsException("Cannot delete file system root.");
        }
        FsInode parent = this.path2inode(parentPath);
        String name2 = filePath.getName();
        this.remove(parent, name2);
    }

    @Override
    public void remove(FsInode parent, String name2) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.remove(dbConnection, parent, name2);
            dbConnection.commit();
        }
        catch (ChimeraFsException hfe) {
            SqlHelper.tryToRollback(dbConnection);
            throw hfe;
        }
        catch (SQLException e) {
            _log.error("delete", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new BackEndErrorHimeraFsException(e.getMessage(), e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void remove(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            FsInode parent = this._sqlDriver.getParentOf(dbConnection, inode);
            if (parent == null) {
                throw new FileNotFoundHimeraFsException("No such file.");
            }
            if (inode.type() != FsInodeType.INODE) {
                throw new FileNotFoundHimeraFsException("Not a file.");
            }
            this._sqlDriver.remove(dbConnection, parent, inode);
            dbConnection.commit();
        }
        catch (ChimeraFsException hfe) {
            SqlHelper.tryToRollback(dbConnection);
            throw hfe;
        }
        catch (SQLException e) {
            _log.error("delete", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new BackEndErrorHimeraFsException(e.getMessage(), e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public Stat stat(String path) throws ChimeraFsException {
        return this.stat(this.path2inode(path));
    }

    @Override
    public Stat stat(FsInode inode) throws ChimeraFsException {
        return this.stat(inode, 0);
    }

    @Override
    public Stat stat(FsInode inode, int level) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        Stat stat = null;
        try {
            dbConnection.setAutoCommit(true);
            stat = this._sqlDriver.stat(dbConnection, inode, level);
        }
        catch (SQLException e) {
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        if (stat == null) {
            throw new FileNotFoundHimeraFsException(inode.toString());
        }
        return stat;
    }

    @Override
    public FsInode mkdir(String path) throws ChimeraFsException {
        int li = path.lastIndexOf(47);
        String file = path.substring(li + 1);
        String dir = li > 1 ? path.substring(0, li) : "/";
        return this.mkdir(this.path2inode(dir), file);
    }

    @Override
    public FsInode mkdir(FsInode parent, String name2) throws ChimeraFsException {
        return this.mkdir(parent, name2, 0, 0, 493);
    }

    @Override
    public FsInode mkdir(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        Connection dbConnection;
        JdbcFs.checkNameLength(name2);
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode inode = null;
        try {
            dbConnection.setAutoCommit(false);
            if ((parent.statCache().getMode() & 0x400) != 0) {
                group = parent.statCache().getGid();
                mode |= 0x400;
            }
            inode = this._sqlDriver.mkdir(dbConnection, parent, name2, owner, group, mode);
            this._sqlDriver.copyTags(dbConnection, parent, inode);
            dbConnection.commit();
        }
        catch (SQLException se) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isDuplicatedKeyError(se)) {
                throw new FileExistsChimeraFsException(name2);
            }
            _log.error("mkdir", se);
            throw new ChimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode path2inode(String path) throws ChimeraFsException {
        return this.path2inode(path, this._rootInode);
    }

    @Override
    public FsInode path2inode(String path, FsInode startFrom) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode inode = null;
        try {
            dbConnection.setAutoCommit(true);
            inode = this._sqlDriver.path2inode(dbConnection, startFrom, path);
            if (inode == null) {
                throw new FileNotFoundHimeraFsException(path);
            }
        }
        catch (SQLException e) {
            _log.error("path2inode", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public List<FsInode> path2inodes(String path) throws ChimeraFsException {
        return this.path2inodes(path, this._rootInode);
    }

    @Override
    public List<FsInode> path2inodes(String path, FsInode startFrom) throws ChimeraFsException {
        List<FsInode> inodes;
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            inodes = this._sqlDriver.path2inodes(dbConnection, startFrom, path);
            if (inodes.isEmpty()) {
                throw new FileNotFoundHimeraFsException(path);
            }
        }
        catch (SQLException e) {
            _log.error("path2inode", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inodes;
    }

    @Override
    public FsInode inodeOf(FsInode parent, String name2) throws ChimeraFsException {
        Connection dbConnection;
        FsInode inode = null;
        if (name2.startsWith(".(")) {
            FsInode useInode;
            int level2;
            String[] cmd;
            if (name2.startsWith(".(id)(")) {
                String[] cmd2 = PnfsCommandProcessor.process(name2);
                if (cmd2.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                inode = this.inodeOf(parent, cmd2[1]);
                return new FsInode_ID(this, inode.toString());
            }
            if (name2.startsWith(".(use)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                try {
                    level2 = Integer.parseInt(cmd[1]);
                    useInode = this.inodeOf(parent, cmd[2]);
                    if (level2 <= 7) {
                        this.stat(useInode, level2);
                        return new FsInode((FileSystemProvider)this, useInode.toString(), level2);
                    }
                }
                catch (NumberFormatException level2) {
                }
                catch (FileNotFoundHimeraFsException e) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
            }
            if (name2.startsWith(".(access)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 2 || cmd.length > 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                try {
                    level2 = cmd.length == 2 ? 0 : Integer.parseInt(cmd[2]);
                    useInode = new FsInode(this, cmd[1]);
                    if (level2 <= 7) {
                        this.stat(useInode, level2);
                        return new FsInode((FileSystemProvider)this, useInode.toString(), level2);
                    }
                }
                catch (NumberFormatException level3) {
                }
                catch (FileNotFoundHimeraFsException e) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
            }
            if (name2.startsWith(".(nameof)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_NAMEOF nameofInode = new FsInode_NAMEOF(this, cmd[1]);
                if (!nameofInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return nameofInode;
            }
            if (name2.startsWith(".(const)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_CONST constInode = new FsInode_CONST(this, parent.toString());
                if (!((FsInode)constInode).exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return constInode;
            }
            if (name2.startsWith(".(parent)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_PARENT parentInode = new FsInode_PARENT(this, cmd[1]);
                if (!parentInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return parentInode;
            }
            if (name2.startsWith(".(pathof)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_PATHOF pathofInode = new FsInode_PATHOF(this, cmd[1]);
                if (!pathofInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return pathofInode;
            }
            if (name2.startsWith(".(tag)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_TAG tagInode = new FsInode_TAG((FileSystemProvider)this, parent.toString(), cmd[1]);
                if (!((FsInode)tagInode).exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return tagInode;
            }
            if (name2.equals(".(tags)()")) {
                return new FsInode_TAGS(this, parent.toString());
            }
            if (name2.startsWith(".(pset)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 2];
                System.arraycopy(cmd, 2, args, 0, args.length);
                FsInode_PSET psetInode = new FsInode_PSET((FileSystemProvider)this, cmd[1], args);
                if (!psetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return psetInode;
            }
            if (name2.equals(".(get)(cursor)")) {
                FsInode_PGET pgetInode = new FsInode_PGET((FileSystemProvider)this, parent.toString(), new String[0]);
                if (!pgetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return pgetInode;
            }
            if (name2.startsWith(".(get)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 1];
                System.arraycopy(cmd, 1, args, 0, args.length);
                inode = this.getPGET(parent, args);
                if (!inode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return inode;
            }
            if (name2.equals(".(config)")) {
                return new FsInode(this, this._wormID);
            }
            if (name2.startsWith(".(config)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return this.inodeOf(new FsInode(this, this._wormID), cmd[1]);
            }
            if (name2.startsWith(".(fset)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 2];
                System.arraycopy(cmd, 2, args, 0, args.length);
                FsInode fsetInode = this.inodeOf(parent, cmd[1]);
                if (!fsetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return new FsInode_PSET((FileSystemProvider)this, fsetInode.toString(), args);
            }
        }
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            inode = this._sqlDriver.inodeOf(dbConnection, parent, name2);
            if (inode == null) {
                throw new FileNotFoundHimeraFsException(name2);
            }
        }
        catch (SQLException e) {
            _log.error("inodeOf", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public String inode2path(FsInode inode) throws ChimeraFsException {
        return this.inode2path(inode, this._rootInode, true);
    }

    @Override
    public String inode2path(FsInode inode, FsInode startFrom, boolean inclusive) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String path = null;
        try {
            dbConnection.setAutoCommit(true);
            path = this._sqlDriver.inode2path(dbConnection, inode, startFrom, inclusive);
        }
        catch (SQLException e) {
            _log.error("inode2path", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return path;
    }

    @Override
    public boolean removeFileMetadata(String path, int level) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean rc = false;
        try {
            dbConnection.setAutoCommit(false);
            rc = this._sqlDriver.removeInodeLevel(dbConnection, this.path2inode(path), level);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("removeFileMetadata", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return rc;
    }

    @Override
    public FsInode getParentOf(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode parent = null;
        try {
            dbConnection.setAutoCommit(true);
            parent = inode.isDirectory() ? this._sqlDriver.getParentOfDirectory(dbConnection, inode) : this._sqlDriver.getParentOf(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("getPathOf", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return parent;
    }

    @Override
    public void setFileName(FsInode dir, String oldName, String newName) throws ChimeraFsException {
        this.move(dir, oldName, dir, newName);
    }

    @Override
    public void setInodeAttributes(FsInode inode, int level, Stat stat) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            switch (inode.type()) {
                case INODE: 
                case PSET: {
                    boolean applied = this._sqlDriver.setInodeAttributes(dbConnection, inode, level, stat);
                    if (applied) break;
                    Stat s = this._sqlDriver.stat(dbConnection, inode);
                    if (s == null) {
                        throw new FileNotFoundHimeraFsException();
                    }
                    if ((s.getMode() & 0xF000) == 16384) {
                        throw new IsDirChimeraException(inode);
                    }
                    throw new InvalidArgumentChimeraException();
                }
                case TAG: {
                    if (stat.isDefined(Stat.StatAttributes.MODE)) {
                        this._sqlDriver.setTagMode(dbConnection, (FsInode_TAG)inode, stat.getMode());
                    }
                    if (stat.isDefined(Stat.StatAttributes.UID)) {
                        this._sqlDriver.setTagOwner(dbConnection, (FsInode_TAG)inode, stat.getUid());
                    }
                    if (!stat.isDefined(Stat.StatAttributes.GID)) break;
                    this._sqlDriver.setTagOwnerGroup(dbConnection, (FsInode_TAG)inode, stat.getGid());
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setInodeAttributes", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public boolean isIoEnabled(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean ioEnabled = false;
        try {
            dbConnection.setAutoCommit(true);
            ioEnabled = this._sqlDriver.isIoEnabled(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("isIoEnabled", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return ioEnabled;
    }

    @Override
    public void setInodeIo(FsInode inode, boolean enable) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setInodeIo(dbConnection, inode, enable);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setInodeIo", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    public int write(FsInode inode, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this.write(inode, 0, beginIndex, data, offset, len);
    }

    @Override
    public int write(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection;
        if (level == 0 && !inode.isIoEnabled()) {
            _log.debug(inode + ": IO (write) not allowd");
            return -1;
        }
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.write(dbConnection, inode, level, beginIndex, data, offset, len);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(e)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("write", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return len;
    }

    public int read(FsInode inode, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this.read(inode, 0, beginIndex, data, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection;
        int count = -1;
        if (level == 0 && !inode.isIoEnabled()) {
            _log.debug(inode + ": IO(read) not allowd");
            return -1;
        }
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            count = this._sqlDriver.read(dbConnection, inode, level, beginIndex, data, offset, len);
        }
        catch (SQLException se) {
            _log.debug("read:", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        catch (IOException e) {
            _log.debug("read IO:", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return count;
    }

    @Override
    public byte[] readLink(String path) throws ChimeraFsException {
        return this.readLink(this.path2inode(path));
    }

    @Override
    public byte[] readLink(FsInode inode) throws ChimeraFsException {
        byte[] b = new byte[(int)inode.statCache().getSize()];
        int n = this.read(inode, 0L, b, 0, b.length);
        byte[] link = n >= 0 ? b : new byte[]{};
        return link;
    }

    @Override
    public boolean move(String source, String dest) {
        boolean rc;
        try {
            File what = new File(source);
            File where = new File(dest);
            rc = this.move(this.path2inode(what.getParent()), what.getName(), this.path2inode(where.getParent()), where.getName());
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    @Override
    public boolean move(FsInode srcDir, String source, FsInode destDir, String dest) throws ChimeraFsException {
        Connection dbConnection;
        JdbcFs.checkNameLength(dest);
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean rc = false;
        try {
            dbConnection.setAutoCommit(false);
            Stat destStat = this._sqlDriver.stat(dbConnection, destDir);
            if ((destStat.getMode() & 0xF000) != 16384) {
                throw new NotDirChimeraException();
            }
            FsInode destInode = this._sqlDriver.inodeOf(dbConnection, destDir, dest);
            FsInode srcInode = this._sqlDriver.inodeOf(dbConnection, srcDir, source);
            if (srcInode == null) {
                throw new FileNotFoundHimeraFsException();
            }
            if (destInode != null) {
                Stat statDest = this._sqlDriver.stat(dbConnection, destInode);
                Stat statSrc = this._sqlDriver.stat(dbConnection, srcInode);
                if (destInode.equals(srcInode)) {
                    dbConnection.commit();
                    boolean bl = false;
                    return bl;
                }
                if ((statSrc.getMode() & 0x3F000) != (statDest.getMode() & 0x3F000)) {
                    throw new FileExistsChimeraFsException();
                }
                this._sqlDriver.remove(dbConnection, destDir, dest);
            }
            if (!srcDir.equals(destDir)) {
                this._sqlDriver.move(dbConnection, srcDir, source, destDir, dest);
                this._sqlDriver.incNlink(dbConnection, destDir);
                this._sqlDriver.decNlink(dbConnection, srcDir);
            } else {
                long now = System.currentTimeMillis();
                this._sqlDriver.setFileName(dbConnection, srcDir, source, dest);
                Stat stat = new Stat();
                stat.setMTime(now);
                this._sqlDriver.setInodeAttributes(dbConnection, destDir, 0, stat);
            }
            dbConnection.commit();
            rc = true;
        }
        catch (SQLException e) {
            _log.error("move:", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return rc;
    }

    @Override
    public List<StorageLocatable> getInodeLocations(FsInode inode, int type) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        List<StorageLocatable> locations = null;
        try {
            dbConnection.setAutoCommit(true);
            locations = this._sqlDriver.getInodeLocations(dbConnection, inode, type);
        }
        catch (SQLException se) {
            _log.error("getInodeLocations", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.addInodeLocation(dbConnection, inode, type, location);
            dbConnection.commit();
        }
        catch (SQLException se) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(se)) {
                throw new FileNotFoundHimeraFsException();
            }
            if (!this._sqlDriver.isDuplicatedKeyError(se)) {
                _log.error("addInodeLocation:", se);
                throw new IOHimeraFsException(se.getMessage());
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void clearInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.clearInodeLocation(dbConnection, inode, type, location);
            dbConnection.commit();
        }
        catch (SQLException se) {
            _log.error("clearInodeLocation", se);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public String[] tags(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String[] list = null;
        try {
            dbConnection.setAutoCommit(true);
            list = this._sqlDriver.tags(dbConnection, inode);
        }
        catch (SQLException se) {
            _log.error("tags", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return list;
    }

    @Override
    public void createTag(FsInode inode, String name2) throws ChimeraFsException {
        this.createTag(inode, name2, 0, 0, 420);
    }

    @Override
    public void createTag(FsInode inode, String name2, int uid, int gid, int mode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.createTag(dbConnection, inode, name2, uid, gid, mode);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isDuplicatedKeyError(e)) {
                throw new FileExistsChimeraFsException();
            }
            _log.error("createTag", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTag(dbConnection, inode, tagName, data, offset, len);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTag", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        catch (ChimeraFsException e) {
            _log.error("setTag", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return len;
    }

    @Override
    public void removeTag(FsInode dir, String tagName) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.removeTag(dbConnection, dir, tagName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("removeTag", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void removeTag(FsInode dir) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.removeTag(dbConnection, dir);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("removeTag", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        int count = -1;
        try {
            dbConnection.setAutoCommit(true);
            count = this._sqlDriver.getTag(dbConnection, inode, tagName, data, offset, len);
        }
        catch (SQLException e) {
            _log.error("getTag", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        catch (IOException e) {
            _log.error("getTag io", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return count;
    }

    @Override
    public Stat statTag(FsInode dir, String name2) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        Stat ret = null;
        try {
            dbConnection.setAutoCommit(true);
            ret = this._sqlDriver.statTag(dbConnection, dir, name2);
        }
        catch (SQLException e) {
            _log.error("statTag", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return ret;
    }

    @Override
    public void setTagOwner(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagOwner(dbConnection, tagInode, owner);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagOwner", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setTagOwnerGroup(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagOwnerGroup(dbConnection, tagInode, owner);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagOwnerGroup", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setTagMode(FsInode_TAG tagInode, String name2, int mode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagMode(dbConnection, tagInode, mode);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagMode", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public int getFsId() {
        return this._fsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStorageInfo(FsInode inode, InodeStorageInformation storageInfo) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setStorageInfo(dbConnection, inode, storageInfo);
            dbConnection.commit();
        }
        catch (SQLException se) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(se)) {
                throw new FileNotFoundHimeraFsException();
            }
            if (!this._sqlDriver.isDuplicatedKeyError(se)) {
                _log.error("setStorageInfo:", se);
                throw new IOHimeraFsException(se.getMessage());
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setAccessLatency(FsInode inode, AccessLatency accessLatency) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setAccessLatency(dbConnection, inode, accessLatency);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(e)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("setAccessLatency:", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setRetentionPolicy(FsInode inode, RetentionPolicy retentionPolicy) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setRetentionPolicy(dbConnection, inode, retentionPolicy);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(e)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("setRetentionPolicy:", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public InodeStorageInformation getStorageInfo(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        InodeStorageInformation storageInfo = null;
        try {
            dbConnection.setAutoCommit(true);
            storageInfo = this._sqlDriver.getStorageInfo(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return storageInfo;
    }

    @Override
    public AccessLatency getAccessLatency(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        AccessLatency accessLatency = null;
        try {
            dbConnection.setAutoCommit(true);
            accessLatency = this._sqlDriver.getAccessLatency(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return accessLatency;
    }

    @Override
    public RetentionPolicy getRetentionPolicy(FsInode inode) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        RetentionPolicy retentionPolicy = null;
        try {
            dbConnection.setAutoCommit(true);
            retentionPolicy = this._sqlDriver.getRetentionPolicy(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return retentionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInodeChecksum(FsInode inode, int type, String checksum) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setInodeChecksum(dbConnection, inode, type, checksum);
            dbConnection.commit();
        }
        catch (SQLException e) {
            SqlHelper.tryToRollback(dbConnection);
            if (this._sqlDriver.isForeignKeyError(e)) {
                throw new FileNotFoundHimeraFsException();
            }
            if (!this._sqlDriver.isDuplicatedKeyError(e)) {
                _log.error("setInodeChecksum:", e);
                throw new IOHimeraFsException(e.getMessage());
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void removeInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            this._sqlDriver.removeInodeChecksum(dbConnection, inode, type);
        }
        catch (SQLException e) {
            _log.error("removeInodeChecksum", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public String getInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        Connection dbConnection;
        String checkSum = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            checkSum = this._sqlDriver.getInodeChecksum(dbConnection, inode, type);
        }
        catch (SQLException e) {
            _log.error("getInodeChecksum", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return checkSum;
    }

    @Override
    public List<ACE> getACL(FsInode inode) throws ChimeraFsException {
        List<ACE> acl;
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            acl = this._sqlDriver.getACL(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("Failed go getACL:", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return acl;
    }

    @Override
    public void setACL(FsInode inode, List<ACE> acl) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setACL(dbConnection, inode, acl);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("Failed to set ACL: ", e);
            SqlHelper.tryToRollback(dbConnection);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    private static void checkNameLength(String name2) throws InvalidNameChimeraException {
        if (name2.length() > 255) {
            throw new InvalidNameChimeraException("Name too long");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsStat getFsStat0() throws ChimeraFsException {
        FsStat fsStat = null;
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
            fsStat = this._sqlDriver.getFsStat(dbConnection);
        }
        catch (SQLException e) {
            _log.error("Failed to obtain FsStat: {}", (Object)e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return fsStat;
    }

    @Override
    public FsStat getFsStat() throws ChimeraFsException {
        try {
            return this._fsStatCache.get(this.DUMMY_KEY);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible(t, ChimeraFsException.class);
            throw new ChimeraFsException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo() {
        String databaseProductName = "Unknown";
        String databaseProductVersion = "Unknown";
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
            if (dbConnection != null) {
                databaseProductName = dbConnection.getMetaData().getDatabaseProductName();
                databaseProductVersion = dbConnection.getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DB        : ").append(this._dbConnectionsPool.toString()).append("\n");
        sb.append("DB Engine : ").append(databaseProductName).append(" ").append(databaseProductVersion).append("\n");
        sb.append("rootID    : ").append(this._rootInode.toString()).append("\n");
        sb.append("wormID    : ").append(this._wormID).append("\n");
        sb.append("FsId      : ").append(this._fsId).append("\n");
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
    }

    private static boolean arrayStartsWith(byte[] a1, byte[] a2) {
        if (a1.length < a2.length) {
            return false;
        }
        for (int i = 0; i < a2.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public FsInode inodeFromBytes(byte[] handle) throws ChimeraFsException {
        if (JdbcFs.arrayStartsWith(handle, FH_V0_REG) || JdbcFs.arrayStartsWith(handle, FH_V0_PFS)) {
            return this.inodeFromBytesOld(handle);
        }
        if (JdbcFs.arrayStartsWith(handle, FH_V0_BIN)) {
            return this.inodeFromBytesNew(InodeId.hexStringToByteArray(new String(handle)));
        }
        return this.inodeFromBytesNew(handle);
    }

    public static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int p = 0;
        for (byte b : bytes) {
            int i = b & 0xFF;
            chars[p++] = HEX[i / 16];
            chars[p++] = HEX[i % 16];
        }
        return new String(chars);
    }

    private String[] getArgs(byte[] bytes) {
        StringTokenizer st = new StringTokenizer(new String(bytes), "[:]");
        int argc = st.countTokens();
        String[] args = new String[argc];
        for (int i = 0; i < argc; ++i) {
            args[i] = st.nextToken();
        }
        return args;
    }

    FsInode inodeFromBytesNew(byte[] handle) throws ChimeraFsException {
        FsInode inode;
        if (handle.length < 4) {
            throw new FileNotFoundHimeraFsException("File handle too short");
        }
        ByteBuffer b = ByteBuffer.wrap(handle);
        byte fsid = b.get();
        byte type = b.get();
        byte idLen = b.get();
        byte[] id = new byte[idLen];
        b.get(id);
        byte opaqueLen = b.get();
        if (opaqueLen > b.remaining()) {
            throw new FileNotFoundHimeraFsException("Bad Opaque len");
        }
        byte[] opaque = new byte[opaqueLen];
        b.get(opaque);
        FsInodeType inodeType = FsInodeType.valueOf(type);
        String inodeId = JdbcFs.toHexString(id);
        switch (inodeType) {
            case INODE: {
                int level = Integer.parseInt(new String(opaque));
                inode = new FsInode((FileSystemProvider)this, inodeId, level);
                break;
            }
            case ID: {
                inode = new FsInode_ID(this, inodeId);
                break;
            }
            case TAGS: {
                inode = new FsInode_TAGS(this, inodeId);
                break;
            }
            case TAG: {
                String tag = new String(opaque);
                inode = new FsInode_TAG((FileSystemProvider)this, inodeId, tag);
                break;
            }
            case NAMEOF: {
                inode = new FsInode_NAMEOF(this, inodeId);
                break;
            }
            case PARENT: {
                inode = new FsInode_PARENT(this, inodeId);
                break;
            }
            case PATHOF: {
                inode = new FsInode_PATHOF(this, inodeId);
                break;
            }
            case CONST: {
                inode = new FsInode_CONST(this, inodeId);
                break;
            }
            case PSET: {
                inode = new FsInode_PSET((FileSystemProvider)this, inodeId, this.getArgs(opaque));
                break;
            }
            case PGET: {
                inode = this.getPGET(inodeId, this.getArgs(opaque));
                break;
            }
            default: {
                throw new FileNotFoundHimeraFsException("Unsupported file handle type: " + (Object)((Object)inodeType));
            }
        }
        return inode;
    }

    FsInode inodeFromBytesOld(byte[] handle) throws ChimeraFsException {
        FsInode inode = null;
        String strHandle = new String(handle);
        StringTokenizer st = new StringTokenizer(strHandle, "[:]");
        if (st.countTokens() < 3) {
            throw new IllegalArgumentException("Invalid HimeraNFS handler.(" + strHandle + ")");
        }
        int fsId = Integer.parseInt(st.nextToken());
        String type = st.nextToken();
        try {
            FsInodeType inodeType = FsInodeType.valueOf(type);
            switch (inodeType) {
                case INODE: {
                    String id = st.nextToken();
                    int level = 0;
                    if (st.countTokens() > 0) {
                        level = Integer.parseInt(st.nextToken());
                    }
                    inode = new FsInode((FileSystemProvider)this, id, level);
                    break;
                }
                case ID: {
                    String id = st.nextToken();
                    inode = new FsInode_ID(this, id);
                    break;
                }
                case TAGS: {
                    String id = st.nextToken();
                    inode = new FsInode_TAGS(this, id);
                    break;
                }
                case TAG: {
                    String id = st.nextToken();
                    String tag = st.nextToken();
                    inode = new FsInode_TAG((FileSystemProvider)this, id, tag);
                    break;
                }
                case NAMEOF: {
                    String id = st.nextToken();
                    inode = new FsInode_NAMEOF(this, id);
                    break;
                }
                case PARENT: {
                    String id = st.nextToken();
                    inode = new FsInode_PARENT(this, id);
                    break;
                }
                case PATHOF: {
                    String id = st.nextToken();
                    inode = new FsInode_PATHOF(this, id);
                    break;
                }
                case CONST: {
                    String cnst = st.nextToken();
                    inode = new FsInode_CONST(this, cnst);
                    break;
                }
                case PSET: {
                    String id = st.nextToken();
                    int argc = st.countTokens();
                    String[] args = new String[argc];
                    for (int i = 0; i < argc; ++i) {
                        args[i] = st.nextToken();
                    }
                    inode = new FsInode_PSET((FileSystemProvider)this, id, args);
                    break;
                }
                case PGET: {
                    String id = st.nextToken();
                    int argc = st.countTokens();
                    String[] args = new String[argc];
                    for (int i = 0; i < argc; ++i) {
                        args[i] = st.nextToken();
                    }
                    inode = this.getPGET(id, args);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            _log.info("Failed to generate an inode from file handle : {} : {}", (Object)strHandle, (Object)iae);
            inode = null;
        }
        return inode;
    }

    @Override
    public byte[] inodeToBytes(FsInode inode) throws ChimeraFsException {
        return inode.getIdentifier();
    }

    protected FsInode_PGET getPGET(String id, String[] args) throws ChimeraFsException {
        return new FsInode_PGET((FileSystemProvider)this, id, args);
    }

    protected FsInode_PGET getPGET(FsInode parent, String[] args) throws ChimeraFsException {
        return new FsInode_PGET((FileSystemProvider)this, parent.toString(), args);
    }
}

