/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.v4.xdr.CB_COMPOUND4args;
import org.dcache.nfs.v4.xdr.CB_COMPOUND4res;
import org.dcache.nfs.v4.xdr.CB_LAYOUTRECALL4args;
import org.dcache.nfs.v4.xdr.CB_SEQUENCE4args;
import org.dcache.nfs.v4.xdr.callback_sec_parms4;
import org.dcache.nfs.v4.xdr.fsid4;
import org.dcache.nfs.v4.xdr.layoutrecall4;
import org.dcache.nfs.v4.xdr.nfs_cb_argop4;
import org.dcache.nfs.v4.xdr.referring_call_list4;
import org.dcache.nfs.v4.xdr.sequenceid4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.slotid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcAuthTypeNone;
import org.dcache.xdr.RpcAuthTypeUnix;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.XdrVoid;

class ClientCB {
    private static final int CB_VERSION = 1;
    private final sessionid4 _session;
    private final RpcAuth _auth;
    private final int _highestSlotId;
    private int _sequenceid = 0;
    private final RpcCall _rpc;

    ClientCB(XdrTransport transport, int program, sessionid4 session, int highestSlotId, callback_sec_parms4[] sec_parms) {
        this._session = session;
        switch (sec_parms[0].cb_secflavor) {
            case 0: {
                this._auth = new RpcAuthTypeNone();
                break;
            }
            case 1: {
                this._auth = new RpcAuthTypeUnix(sec_parms[0].cbsp_sys_cred.uid, sec_parms[0].cbsp_sys_cred.gid, sec_parms[0].cbsp_sys_cred.gids, sec_parms[0].cbsp_sys_cred.stamp, sec_parms[0].cbsp_sys_cred.machinename);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsuppotred security flavor");
            }
        }
        this._highestSlotId = highestSlotId - 1;
        this._rpc = new RpcCall(program, 1, this._auth, transport);
    }

    public String toString() {
        return "tcp:///" + this._rpc;
    }

    public void cbPing() throws OncRpcException, IOException {
        this._rpc.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
    }

    private XdrAble generateCompound(String tag, nfs_cb_argop4 ... cbOperations) {
        ++this._sequenceid;
        CB_SEQUENCE4args cbSequence = new CB_SEQUENCE4args();
        cbSequence.csa_cachethis = false;
        cbSequence.csa_highest_slotid = new slotid4(this._highestSlotId);
        cbSequence.csa_sequenceid = new sequenceid4(this._sequenceid);
        cbSequence.csa_slotid = new slotid4(0);
        cbSequence.csa_sessionid = this._session;
        cbSequence.csa_referring_call_lists = new referring_call_list4[0];
        CB_COMPOUND4args cbCompound = new CB_COMPOUND4args();
        cbCompound.argarray = new nfs_cb_argop4[cbOperations.length + 1];
        cbCompound.argarray[0] = new nfs_cb_argop4();
        cbCompound.argarray[0].argop = 11;
        cbCompound.argarray[0].opcbsequence = cbSequence;
        System.arraycopy(cbOperations, 0, cbCompound.argarray, 1, cbOperations.length);
        cbCompound.minorversion = new uint32_t(1);
        cbCompound.callback_ident = new uint32_t(0);
        cbCompound.tag = new utf8str_cs(tag);
        return cbCompound;
    }

    public void cbLauoutrecallAll() throws OncRpcException, IOException {
        CB_LAYOUTRECALL4args cbLayoutrecall = new CB_LAYOUTRECALL4args();
        cbLayoutrecall.clora_changed = true;
        cbLayoutrecall.clora_type = 1;
        cbLayoutrecall.clora_iomode = 3;
        cbLayoutrecall.clora_recall = new layoutrecall4();
        cbLayoutrecall.clora_recall.lor_recalltype = 2;
        cbLayoutrecall.clora_recall.lor_fsid = new fsid4();
        cbLayoutrecall.clora_recall.lor_fsid.major = new uint64_t(17L);
        cbLayoutrecall.clora_recall.lor_fsid.minor = new uint64_t(17L);
        nfs_cb_argop4 opArgs = new nfs_cb_argop4();
        opArgs.argop = 5;
        opArgs.opcblayoutrecall = cbLayoutrecall;
        XdrAble args = this.generateCompound("cb_layout_recall", opArgs);
        this._rpc.call(1, args, new CB_COMPOUND4res());
    }
}

