/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.ACCESS4res;
import org.dcache.nfs.v4.xdr.ACCESS4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationACCESS
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationACCESS.class);

    public OperationACCESS(nfs_argop4 args) {
        super(args, 3);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        ACCESS4res res = result.opaccess;
        int requestedAccess = this._args.opaccess.access.value;
        int realAccess = context.getFs().access(context.currentInode(), requestedAccess);
        _log.debug("NFS Request ACCESS uid: {} {} {}", context.getSubject(), requestedAccess, realAccess);
        res.resok4 = new ACCESS4resok();
        res.resok4.access = new uint32_t(realAccess);
        res.resok4.supported = new uint32_t(requestedAccess);
        res.status = 0;
    }
}

