/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.Optional;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadTypeException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.AttributeMap;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.xdr.CREATE4res;
import org.dcache.nfs.v4.xdr.CREATE4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCREATE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCREATE.class);

    public OperationCREATE(nfs_argop4 args) {
        super(args, 6);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        Inode inode;
        CREATE4res res = result.opcreate;
        fattr4 objAttr = this._args.opcreate.createattrs;
        int type = this._args.opcreate.objtype.type;
        Stat stat = context.getFs().getattr(context.currentInode());
        String name2 = NameFilter.convertName(this._args.opcreate.objname.value);
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException();
        }
        AttributeMap attributeMap = new AttributeMap(objAttr);
        bitmap4 appliedAttribytes = bitmap4.of(0);
        int mode = 700;
        Optional createMode = attributeMap.get(33);
        if (createMode.isPresent()) {
            mode = ((mode4)createMode.get()).value;
            appliedAttribytes.set(33);
        }
        switch (type) {
            case 2: {
                inode = context.getFs().mkdir(context.currentInode(), name2, context.getSubject(), mode);
                break;
            }
            case 5: {
                String linkDest = NameFilter.convertPath(this._args.opcreate.objtype.linkdata.value.value);
                inode = context.getFs().symlink(context.currentInode(), name2, linkDest, context.getSubject(), mode);
                break;
            }
            case 3: {
                inode = context.getFs().create(context.currentInode(), Stat.Type.BLOCK, name2, context.getSubject(), mode);
                break;
            }
            case 4: {
                inode = context.getFs().create(context.currentInode(), Stat.Type.CHAR, name2, context.getSubject(), mode);
                break;
            }
            case 7: {
                inode = context.getFs().create(context.currentInode(), Stat.Type.FIFO, name2, context.getSubject(), mode);
                break;
            }
            case 6: {
                inode = context.getFs().create(context.currentInode(), Stat.Type.SOCK, name2, context.getSubject(), mode);
                break;
            }
            case 8: 
            case 9: {
                throw new NotSuppException("create of this type not supported");
            }
            case 1: {
                throw new BadTypeException("create of regular files handled by OPEN");
            }
            default: {
                throw new BadTypeException("bad file type: " + type);
            }
        }
        res.status = 0;
        res.resok4 = new CREATE4resok();
        res.resok4.attrset = appliedAttribytes;
        res.resok4.cinfo = new change_info4();
        res.resok4.cinfo.atomic = true;
        res.resok4.cinfo.before = new changeid4(stat.getMTime());
        res.resok4.cinfo.after = new changeid4(System.currentTimeMillis());
        context.currentInode(inode);
    }
}

