/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.Optional;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.GraceException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NoGraceException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.status.SymlinkException;
import org.dcache.nfs.status.WrongTypeException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.AttributeMap;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.OperationSETATTR;
import org.dcache.nfs.v4.xdr.OPEN4res;
import org.dcache.nfs.v4.xdr.OPEN4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.fattr4_size;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.open_delegation4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN.class);

    public OperationOPEN(nfs_argop4 args) {
        super(args, 18);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        NFS4Client client;
        OPEN4res res = result.opopen;
        if (context.getMinorversion() > 0) {
            client = context.getSession().getClient();
        } else {
            Long clientid = this._args.opopen.owner.value.clientid.value;
            client = context.getStateHandler().getClientByID(clientid);
            if (client == null || !client.isConfirmed()) {
                throw new StaleClientidException("bad client id.");
            }
            client.validateSequence(this._args.opopen.seqid);
            client.updateLeaseTime();
            _log.debug("open request form clientid: {}, owner: {}", (Object)client, (Object)new String(this._args.opopen.owner.value.owner));
        }
        res.resok4 = new OPEN4resok();
        res.resok4.attrset = new bitmap4();
        res.resok4.attrset.value = new int[]{0, 0};
        res.resok4.delegation = new open_delegation4();
        res.resok4.delegation.delegation_type = 0;
        res.resok4.cinfo = new change_info4();
        res.resok4.cinfo.atomic = true;
        switch (this._args.opopen.claim.claim) {
            case 0: {
                Inode inode;
                if (client.needReclaim() && !context.getStateHandler().hasGracePeriodExpired()) {
                    throw new GraceException();
                }
                Stat stat = context.getFs().getattr(context.currentInode());
                if (stat.type() != Stat.Type.DIRECTORY) {
                    throw new NotDirException();
                }
                res.resok4.cinfo.before = new changeid4(stat.getCTime());
                String name2 = NameFilter.convertName(this._args.opopen.claim.file.value);
                _log.debug("regular open for : {}", (Object)name2);
                if (this._args.opopen.openhow.opentype == 1) {
                    boolean exclusive = this._args.opopen.openhow.how.mode == 2 || this._args.opopen.openhow.how.mode == 3;
                    try {
                        Optional createSize;
                        AttributeMap attributeMap;
                        int mode = 384;
                        bitmap4 appliedAttribytes = bitmap4.of(0);
                        switch (this._args.opopen.openhow.how.mode) {
                            case 0: 
                            case 1: {
                                attributeMap = new AttributeMap(this._args.opopen.openhow.how.createattrs);
                                break;
                            }
                            case 2: {
                                attributeMap = new AttributeMap(null);
                                break;
                            }
                            case 3: {
                                attributeMap = new AttributeMap(this._args.opopen.openhow.how.ch_createboth.cva_attrs);
                                break;
                            }
                            default: {
                                throw new BadXdrException("bad value: " + this._args.opopen.openhow.how.mode);
                            }
                        }
                        Optional createMode = attributeMap.get(33);
                        if (createMode.isPresent()) {
                            mode = ((mode4)createMode.get()).value;
                            appliedAttribytes.set(33);
                        }
                        if ((createSize = attributeMap.get(4)).isPresent() && ((fattr4_size)createSize.get()).value == 0L) {
                            appliedAttribytes.set(4);
                        }
                        _log.debug("Creating a new file: {}", (Object)name2);
                        inode = context.getFs().create(context.currentInode(), Stat.Type.REGULAR, name2, context.getSubject(), mode);
                        res.resok4.cinfo.after = new changeid4(System.currentTimeMillis());
                    }
                    catch (ExistException e) {
                        if (exclusive) {
                            throw new ExistException();
                        }
                        res.resok4.cinfo.after = new changeid4(stat.getCTime());
                        inode = context.getFs().lookup(context.currentInode(), name2);
                        if (_log.isDebugEnabled()) {
                            Stat fileStat = context.getFs().getattr(context.currentInode());
                            _log.debug("Opening existing file: {}, uid: {}, gid: {}, mode: 0{}", name2, fileStat.getUid(), fileStat.getGid(), Integer.toOctalString(fileStat.getMode() & 0x1FF));
                        }
                        if (context.getFs().access(inode, 4) == 0) {
                            throw new AccessException();
                        }
                        OperationSETATTR.setAttributes(this._args.opopen.openhow.how.createattrs, inode, context);
                    }
                } else {
                    res.resok4.cinfo.after = new changeid4(stat.getCTime());
                    inode = context.getFs().lookup(context.currentInode(), name2);
                    stat = context.getFs().getattr(inode);
                    if ((this._args.opopen.share_access.value & 1) != 0 && context.getFs().access(inode, 1) == 0) {
                        throw new AccessException();
                    }
                    if ((this._args.opopen.share_access.value & 2) != 0 && context.getFs().access(inode, 4) == 0) {
                        throw new AccessException();
                    }
                    if (stat.type() == Stat.Type.DIRECTORY) {
                        throw new IsDirException();
                    }
                    if (stat.type() == Stat.Type.SYMLINK) {
                        throw new SymlinkException();
                    }
                    if (stat.type() != Stat.Type.REGULAR) {
                        if (context.getMinorversion() == 0) {
                            throw new SymlinkException();
                        }
                        throw new WrongTypeException();
                    }
                }
                context.currentInode(inode);
                break;
            }
            case 1: {
                if (context.getStateHandler().hasGracePeriodExpired()) {
                    throw new NoGraceException("Server not in grace period");
                }
                if (!client.needReclaim()) {
                    throw new NoGraceException("CLAIM open after 'reclaim complete'");
                }
            }
            case 4: {
                _log.debug("open by Inode for : {}", (Object)context.currentInode());
                res.resok4.cinfo.before = new changeid4(0L);
                res.resok4.cinfo.after = new changeid4(0L);
                Inode inode = context.currentInode();
                Stat stat = context.getFs().getattr(inode);
                if (this._args.opopen.share_access.value == 1 && context.getFs().access(inode, 1) == 0) {
                    throw new AccessException();
                }
                if ((this._args.opopen.share_access.value == 3 || this._args.opopen.share_access.value == 2) && context.getFs().access(inode, 4) == 0) {
                    throw new AccessException();
                }
                if (stat.type() == Stat.Type.DIRECTORY) {
                    throw new IsDirException();
                }
                if (stat.type() != Stat.Type.SYMLINK) break;
                throw new SymlinkException();
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                _log.warn("Unimplemented open claim: {}", (Object)this._args.opopen.claim.claim);
                throw new InvalException("Unimplemented open claim: {}" + this._args.opopen.claim.claim);
            }
            default: {
                _log.warn("BAD open claim: {}", (Object)this._args.opopen.claim.claim);
                throw new InvalException("BAD open claim: {}" + this._args.opopen.claim.claim);
            }
        }
        res.resok4.rflags = context.getMinorversion() > 0 ? new uint32_t(4) : new uint32_t(6);
        NFS4State nfs4state = client.createState();
        res.resok4.stateid = nfs4state.stateid();
        _log.debug("New stateID: {}", (Object)nfs4state.stateid());
        res.status = 0;
    }
}

