/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.AttrNotSuppException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.SETATTR4res;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_acl;
import org.dcache.nfs.v4.xdr.int32_t;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.settime4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.xdr.BadXdrOncRpcException;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.dcache.xdr.XdrDecodingStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETATTR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSETATTR.class);

    public OperationSETATTR(nfs_argop4 args) {
        super(args, 34);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        SETATTR4res res = result.opsetattr;
        try {
            res.status = 0;
            res.attrsset = OperationSETATTR.setAttributes(this._args.opsetattr.obj_attributes, context.currentInode(), context);
        }
        catch (ChimeraNFSException e) {
            res.attrsset = new bitmap4(new int[]{0, 0});
            throw e;
        }
    }

    static bitmap4 setAttributes(fattr4 attributes, Inode inode, CompoundContext context) throws IOException, OncRpcException {
        XdrBuffer xdr = new XdrBuffer(attributes.attr_vals.value);
        xdr.beginDecoding();
        bitmap4 processedAttributes = new bitmap4(new int[0]);
        Stat stat = new Stat();
        try {
            for (int i : attributes.attrmask) {
                if (OperationSETATTR.xdr2fattr(i, stat, inode, context, xdr)) {
                    _log.debug("   setAttributes : {} ({}) OK", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
                    processedAttributes.set(i);
                    continue;
                }
                _log.debug("   setAttributes : {} ({}) NOT SUPPORTED", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
                throw new AttrNotSuppException("attribute " + OperationGETATTR.attrMask2String(i) + " not supported");
            }
        }
        catch (BadXdrOncRpcException e) {
            throw new BadXdrException(e.getMessage());
        }
        if (xdr.hasMoreData()) {
            throw new BadXdrException("garbage in attr bitmap");
        }
        xdr.endDecoding();
        context.getFs().setattr(inode, stat);
        return processedAttributes;
    }

    static boolean xdr2fattr(int fattr, Stat stat, Inode inode, CompoundContext context, XdrDecodingStream xdr) throws IOException, OncRpcException {
        boolean isApplied = false;
        _log.debug("    FileAttribute: {}", (Object)fattr);
        switch (fattr) {
            case 4: {
                uint64_t size = new uint64_t();
                size.xdrDecode(xdr);
                stat.setSize(size.value);
                isApplied = true;
                break;
            }
            case 12: {
                fattr4_acl acl = new fattr4_acl();
                acl.xdrDecode(xdr);
                context.getFs().setAcl(inode, acl.value);
                stat.setMTime(System.currentTimeMillis());
                isApplied = true;
                break;
            }
            case 14: {
                int32_t isArchive = new int32_t();
                isArchive.xdrDecode(xdr);
                isApplied = false;
                break;
            }
            case 25: {
                int32_t isHidden = new int32_t();
                isHidden.xdrDecode(xdr);
                isApplied = false;
                break;
            }
            case 32: {
                utf8str_cs mimeType = new utf8str_cs();
                mimeType.xdrDecode(xdr);
                isApplied = false;
                break;
            }
            case 33: {
                mode4 mode = new mode4();
                mode.xdrDecode(xdr);
                stat.setMode(mode.value);
                context.getFs().setAcl(inode, Acls.adjust(context.getFs().getAcl(inode), mode.value));
                isApplied = true;
                break;
            }
            case 36: {
                utf8str_cs owner = new utf8str_cs();
                owner.xdrDecode(xdr);
                String new_owner = owner.toString();
                stat.setUid(context.getFs().getIdMapper().principalToUid(new_owner));
                isApplied = true;
                break;
            }
            case 37: {
                utf8str_cs owner_group = new utf8str_cs();
                owner_group.xdrDecode(xdr);
                String new_group = owner_group.toString();
                stat.setGid(context.getFs().getIdMapper().principalToGid(new_group));
                isApplied = true;
                break;
            }
            case 46: {
                int32_t isSystem = new int32_t();
                isSystem.xdrDecode(xdr);
                isApplied = false;
                break;
            }
            case 48: {
                settime4 atime = new settime4();
                atime.xdrDecode(xdr);
                isApplied = true;
                break;
            }
            case 49: {
                nfstime4 btime = new nfstime4();
                btime.xdrDecode(xdr);
                isApplied = false;
                break;
            }
            case 50: {
                nfstime4 ctime = new nfstime4();
                ctime.xdrDecode(xdr);
                stat.setCTime(ctime.toMillis());
                isApplied = true;
                break;
            }
            case 54: {
                settime4 setMtime = new settime4();
                setMtime.xdrDecode(xdr);
                long realMtime = setMtime.set_it == 0 ? System.currentTimeMillis() : setMtime.time.toMillis();
                stat.setMTime(realMtime);
                isApplied = true;
                break;
            }
            case 0: {
                throw new InvalException("setattr of read-only attributes");
            }
        }
        if (!isApplied) {
            _log.info("Attribute not applied: {}", (Object)OperationGETATTR.attrMask2String(fattr));
        }
        return isApplied;
    }
}

