/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;
import org.dcache.auth.Subjects;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirNotEmptyHimeraFsException;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.InvalidArgumentChimeraException;
import org.dcache.chimera.IsDirChimeraException;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.nfs.status.BadOwnerException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.NotEmptyException;
import org.dcache.nfs.status.StaleException;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.aceflag4;
import org.dcache.nfs.v4.xdr.acemask4;
import org.dcache.nfs.v4.xdr.acetype4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChimeraVfs
implements VirtualFileSystem,
AclCheckable {
    private static final Logger _log = LoggerFactory.getLogger(ChimeraVfs.class);
    private final JdbcFs _fs;
    private final NfsIdMapping _idMapping;

    public ChimeraVfs(JdbcFs fs, NfsIdMapping idMapping) {
        this._fs = fs;
        this._idMapping = idMapping;
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this.toInode(FsInode.getRoot(this._fs));
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = parentFsInode.inodeOf(path);
            return this.toInode(fsInode);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("Path Do not exist.");
        }
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid(subject);
        int gid = (int)Subjects.getPrimaryGid(subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = this._fs.createFile(parentFsInode, path, uid, gid, mode | this.typeToChimera(type), this.typeToChimera(type));
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    @Override
    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid(subject);
        int gid = (int)Subjects.getPrimaryGid(subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = parentFsInode.mkdir(path, uid, gid, mode);
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode linkInode = this.toFsInode(link);
        try {
            FsInode fsInode = this._fs.createHLink(parentFsInode, linkInode, path);
            return this.toInode(fsInode);
        }
        catch (NotDirChimeraException e) {
            throw new NotDirException("parent not a directory");
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid(subject);
        int gid = (int)Subjects.getPrimaryGid(subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = this._fs.createLink(parentFsInode, path, uid, gid, mode, link.getBytes(StandardCharsets.UTF_8));
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.read(offset, data, 0, count);
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        FsInode from = this.toFsInode(src);
        FsInode to = this.toFsInode(dest);
        try {
            return this._fs.move(from, oldName, to, newName);
        }
        catch (NotDirChimeraException e) {
            throw new NotDirException("not a directory");
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("destination exists");
        }
        catch (DirNotEmptyHimeraFsException e) {
            throw new NotEmptyException("directory exist and not empty");
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("file not found");
        }
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        int count;
        byte[] data;
        FsInode fsInode = this.toFsInode(inode);
        int n = this._fs.read(fsInode, 0L, data = new byte[count = (int)fsInode.statCache().getSize()], 0, count);
        if (n < 0) {
            throw new NfsIoException("Can't read symlink");
        }
        return new String(data, 0, n, StandardCharsets.UTF_8);
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        try {
            this._fs.remove(parentFsInode, path);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("path not found");
        }
        catch (DirNotEmptyHimeraFsException e) {
            throw new NotEmptyException("directory not empty");
        }
    }

    @Override
    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        int bytesWritten = fsInode.write(offset, data, 0, count);
        return new VirtualFileSystem.WriteResult(VirtualFileSystem.StabilityLevel.FILE_SYNC, bytesWritten);
    }

    @Override
    public void commit(Inode inode, long offset, int count) throws IOException {
    }

    @Override
    public List<DirectoryEntry> list(Inode inode) throws IOException {
        FsInode parentFsInode = this.toFsInode(inode);
        List<HimeraDirectoryEntry> list = DirectoryStreamHelper.listOf(parentFsInode);
        return Lists.transform(list, new ChimeraDirectoryEntryToVfs());
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        FsInode parent = this.toFsInode(inode).getParent();
        if (parent == null) {
            throw new NoEntException("no parent");
        }
        return this.toInode(parent);
    }

    @Override
    public FsStat getFsStat() throws IOException {
        org.dcache.chimera.FsStat fsStat = this._fs.getFsStat();
        return new FsStat(fsStat.getTotalSpace(), fsStat.getTotalFiles(), fsStat.getUsedSpace(), fsStat.getUsedFiles());
    }

    private FsInode toFsInode(Inode inode) throws IOException {
        return this._fs.inodeFromBytes(inode.getFileId());
    }

    private Inode toInode(FsInode inode) {
        try {
            return Inode.forFile(this._fs.inodeToBytes(inode));
        }
        catch (ChimeraFsException e) {
            throw new RuntimeException("bug found", e);
        }
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            return ChimeraVfs.fromChimeraStat(fsInode.stat(), fsInode.id());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("Path Do not exist.");
        }
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            fsInode.setStat(ChimeraVfs.toChimeraStat(stat));
        }
        catch (InvalidArgumentChimeraException e) {
            throw new InvalException(e.getMessage());
        }
        catch (IsDirChimeraException e) {
            throw new IsDirException(e.getMessage());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            List<ACE> dacl = this._fs.getACL(fsInode);
            org.dcache.chimera.posix.Stat stat = fsInode.statCache();
            nfsace4[] unixAcl = Acls.of(stat.getMode(), fsInode.isDirectory());
            nfsace4[] aces = new nfsace4[dacl.size() + unixAcl.length];
            int i = 0;
            for (ACE ace : dacl) {
                aces[i] = ChimeraVfs.valueOf(ace, this._idMapping);
                ++i;
            }
            System.arraycopy(unixAcl, 0, aces, i, unixAcl.length);
            return Acls.compact(aces);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        ArrayList<ACE> dacl = new ArrayList<ACE>();
        for (nfsace4 ace : acl) {
            dacl.add(ChimeraVfs.valueOf(ace, this._idMapping));
        }
        try {
            this._fs.setACL(fsInode, dacl);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    private static Stat fromChimeraStat(org.dcache.chimera.posix.Stat pStat, long fileid) {
        Stat stat = new Stat();
        stat.setATime(pStat.getATime());
        stat.setCTime(pStat.getCTime());
        stat.setMTime(pStat.getMTime());
        stat.setGid(pStat.getGid());
        stat.setUid(pStat.getUid());
        stat.setDev(pStat.getDev());
        stat.setIno(pStat.getIno());
        stat.setMode(pStat.getMode());
        stat.setNlink(pStat.getNlink());
        stat.setRdev(pStat.getRdev());
        stat.setSize(pStat.getSize());
        stat.setFileid(fileid);
        stat.setGeneration(pStat.getGeneration());
        return stat;
    }

    private static org.dcache.chimera.posix.Stat toChimeraStat(Stat stat) {
        org.dcache.chimera.posix.Stat pStat = new org.dcache.chimera.posix.Stat();
        if (stat.isDefined(Stat.StatAttribute.ATIME)) {
            pStat.setATime(stat.getATime());
        }
        if (stat.isDefined(Stat.StatAttribute.CTIME)) {
            pStat.setCTime(stat.getCTime());
        }
        if (stat.isDefined(Stat.StatAttribute.MTIME)) {
            pStat.setMTime(stat.getMTime());
        }
        if (stat.isDefined(Stat.StatAttribute.GROUP)) {
            pStat.setGid(stat.getGid());
        }
        if (stat.isDefined(Stat.StatAttribute.OWNER)) {
            pStat.setUid(stat.getUid());
        }
        if (stat.isDefined(Stat.StatAttribute.DEV)) {
            pStat.setDev(stat.getDev());
        }
        if (stat.isDefined(Stat.StatAttribute.INO)) {
            pStat.setIno(stat.getIno());
        }
        if (stat.isDefined(Stat.StatAttribute.MODE)) {
            pStat.setMode(stat.getMode());
        }
        if (stat.isDefined(Stat.StatAttribute.NLINK)) {
            pStat.setNlink(stat.getNlink());
        }
        if (stat.isDefined(Stat.StatAttribute.RDEV)) {
            pStat.setRdev(stat.getRdev());
        }
        if (stat.isDefined(Stat.StatAttribute.SIZE)) {
            pStat.setSize(stat.getSize());
        }
        if (stat.isDefined(Stat.StatAttribute.GENERATION)) {
            pStat.setGeneration(stat.getGeneration());
        }
        return pStat;
    }

    @Override
    public int access(Inode inode, int mode) throws IOException {
        FsInode fsInode;
        int accessmask = mode;
        if ((mode & 0xC) != 0 && this.shouldRejectUpdates(fsInode = this.toFsInode(inode))) {
            accessmask ^= 0xC;
        }
        return accessmask;
    }

    private boolean shouldRejectUpdates(FsInode fsInode) throws ChimeraFsException {
        return fsInode.type() == FsInodeType.INODE && fsInode.getLevel() == 0 && !fsInode.isDirectory() && (!this._fs.getInodeLocations(fsInode, 0).isEmpty() || !this._fs.getInodeLocations(fsInode, 1).isEmpty());
    }

    @Override
    public boolean hasIOLayout(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.type() == FsInodeType.INODE && fsInode.getLevel() == 0;
    }

    @Override
    public AclCheckable getAclCheckable() {
        return this;
    }

    @Override
    public NfsIdMapping getIdMapper() {
        return this._idMapping;
    }

    private int typeToChimera(Stat.Type type) {
        switch (type) {
            case SYMLINK: {
                return 40960;
            }
            case DIRECTORY: {
                return 16384;
            }
            case SOCK: {
                return 49152;
            }
            case FIFO: {
                return 4096;
            }
            case BLOCK: {
                return 24576;
            }
            case CHAR: {
                return 8192;
            }
        }
        return 32768;
    }

    private static nfsace4 valueOf(ACE ace, NfsIdMapping idMapping) {
        String principal;
        switch (ace.getWho()) {
            case USER: {
                principal = idMapping.uidToPrincipal(ace.getWhoID());
                break;
            }
            case GROUP: {
                principal = idMapping.gidToPrincipal(ace.getWhoID());
                break;
            }
            default: {
                principal = ace.getWho().getAbbreviation();
            }
        }
        nfsace4 nfsace = new nfsace4();
        nfsace.access_mask = new acemask4(new uint32_t(ace.getAccessMsk()));
        nfsace.flag = new aceflag4(new uint32_t(ace.getFlags()));
        nfsace.type = new acetype4(new uint32_t(ace.getType().getValue()));
        nfsace.who = new utf8str_mixed(principal);
        return nfsace;
    }

    private static ACE valueOf(nfsace4 ace, NfsIdMapping idMapping) throws BadOwnerException {
        String principal = ace.who.toString();
        int type = ace.type.value.value;
        int flags = ace.flag.value.value;
        int mask = ace.access_mask.value.value;
        int id = -1;
        Who who = Who.fromAbbreviation(principal);
        if (who == null) {
            boolean isGroup = AceFlags.IDENTIFIER_GROUP.matches(flags);
            if (isGroup) {
                who = Who.GROUP;
                id = idMapping.principalToGid(principal);
            } else {
                who = Who.USER;
                id = idMapping.principalToUid(principal);
            }
        }
        return new ACE(AceType.valueOf(type), flags, mask, who, id, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
    }

    @Override
    public AclCheckable.Access checkAcl(Subject subject, Inode inode, int access) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        List<ACE> acl = this._fs.getACL(fsInode);
        org.dcache.chimera.posix.Stat stat = this._fs.stat(fsInode);
        return this.checkAcl(subject, acl, stat.getUid(), stat.getGid(), access);
    }

    private AclCheckable.Access checkAcl(Subject subject, List<ACE> acl, int owner, int group, int access) {
        for (ACE ace : acl) {
            Who who;
            int ace_mask;
            int flag = ace.getFlags();
            if ((flag & 8) != 0 || ace.getType() != AceType.ACCESS_ALLOWED_ACE_TYPE && ace.getType() != AceType.ACCESS_DENIED_ACE_TYPE || ((ace_mask = ace.getAccessMsk()) & access) == 0 || (who = ace.getWho()) != Who.EVERYONE && !(who == Who.OWNER & Subjects.hasUid(subject, owner)) && !(who == Who.OWNER_GROUP & Subjects.hasGid(subject, group)) && !(who == Who.GROUP & Subjects.hasGid(subject, ace.getWhoID())) && !(who == Who.USER & Subjects.hasUid(subject, ace.getWhoID()))) continue;
            if (ace.getType() == AceType.ACCESS_DENIED_ACE_TYPE) {
                return AclCheckable.Access.DENY;
            }
            return AclCheckable.Access.ALLOW;
        }
        return AclCheckable.Access.UNDEFINED;
    }

    private class ChimeraDirectoryEntryToVfs
    implements Function<HimeraDirectoryEntry, DirectoryEntry> {
        private ChimeraDirectoryEntryToVfs() {
        }

        @Override
        public DirectoryEntry apply(HimeraDirectoryEntry e) {
            return new DirectoryEntry(e.getName(), ChimeraVfs.this.toInode(e.getInode()), ChimeraVfs.fromChimeraStat(e.getStat(), e.getInode().id()));
        }
    }
}

