/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;

class LazyParamAwareEvaluationContext
extends StandardEvaluationContext {
    private final ParameterNameDiscoverer paramDiscoverer;
    private final Method method;
    private final Object[] args;
    private final Class<?> targetClass;
    private final Map<String, Method> methodCache;
    private boolean paramLoaded = false;

    LazyParamAwareEvaluationContext(Object rootObject, ParameterNameDiscoverer paramDiscoverer, Method method, Object[] args, Class<?> targetClass, Map<String, Method> methodCache) {
        super(rootObject);
        this.paramDiscoverer = paramDiscoverer;
        this.method = method;
        this.args = args;
        this.targetClass = targetClass;
        this.methodCache = methodCache;
    }

    @Override
    public Object lookupVariable(String name2) {
        Object variable = super.lookupVariable(name2);
        if (variable != null) {
            return variable;
        }
        if (!this.paramLoaded) {
            this.loadArgsAsVariables();
            this.paramLoaded = true;
            variable = super.lookupVariable(name2);
        }
        return variable;
    }

    private void loadArgsAsVariables() {
        if (ObjectUtils.isEmpty(this.args)) {
            return;
        }
        String methodKey = this.toString(this.method);
        Method targetMethod = this.methodCache.get(methodKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(this.method, this.targetClass);
            if (targetMethod == null) {
                targetMethod = this.method;
            }
            this.methodCache.put(methodKey, targetMethod);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.setVariable("a" + i, this.args[i]);
            this.setVariable("p" + i, this.args[i]);
        }
        String[] parameterNames = this.paramDiscoverer.getParameterNames(targetMethod);
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                this.setVariable(parameterNames[i], this.args[i]);
            }
        }
    }

    private String toString(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append("#");
        sb.append(m.toString());
        return sb.toString();
    }
}

