/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.nio.charset.StandardCharsets;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_TAG
extends FsInode {
    private final String _tag;

    public FsInode_TAG(FileSystemProvider fs, String id, String tag) {
        super(fs, id, FsInodeType.TAG);
        this._tag = tag;
    }

    @Override
    public boolean exists() {
        boolean rc = false;
        try {
            String[] list;
            for (String tag : list = this._fs.tags(this)) {
                if (!tag.equals(this._tag)) continue;
                rc = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        if (!this.exists()) {
            throw new FileNotFoundHimeraFsException("tag do not exist");
        }
        Stat ret = this._fs.statTag(this, this._tag);
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        int ret = -1;
        try {
            ret = this._fs.setTag(this, this._tag, data, offset, len);
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        int ret = -1;
        try {
            ret = this._fs.getTag(this, this._tag, data, offset, len);
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public byte[] getIdentifier() {
        return this.byteBase(this._tag.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsInode_TAG)) {
            return false;
        }
        return super.equals(o) && this._tag.equals(((FsInode_TAG)o)._tag);
    }

    public String tagName() {
        return this._tag;
    }

    @Override
    public int hashCode() {
        return 17;
    }
}

