/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsSqlDriver;
import org.dcache.chimera.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OracleFsSqlDriver
extends FsSqlDriver {
    private static final Logger _log = LoggerFactory.getLogger(OracleFsSqlDriver.class);
    private static final String sqlInode2Path = "SELECT iname, LEVEL AS deep FROM (SELECT * FROM  t_dirs WHERE iname !='.' AND iname !='..') start with ipnfsid=? CONNECT BY  ipnfsid = PRIOR iparent ORDER BY deep DESC";

    protected OracleFsSqlDriver() {
        _log.info("Running Oracle specific Driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String inode2path(Connection dbConnection, FsInode inode, FsInode startFrom, boolean inclusive) throws SQLException {
        String path = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            ps = dbConnection.prepareStatement(sqlInode2Path);
            ps.setString(1, inode.toString());
            result = ps.executeQuery();
            StringBuilder sb = new StringBuilder();
            while (result.next()) {
                sb.append("/").append(result.getString("iname"));
            }
            path = sb.toString();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(ps);
        return path;
    }
}

