/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Strings.class);
    private static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final Function<Class, String> GET_SIMPLE_NAME = new Function<Class, String>(){

        @Override
        public String apply(Class c) {
            return c.getSimpleName();
        }
    };

    public static String[] splitArgumentString(String argumentString) {
        LOGGER.debug("splitting argument string {}", (Object)argumentString);
        if (argumentString == null) {
            return ZERO_LENGTH_STRING_ARRAY;
        }
        argumentString = argumentString.trim();
        Pattern regex = Pattern.compile("\"([^\"]*)\"|'([^']*)'|([^\\s]+)");
        Matcher regexMatcher = regex.matcher(argumentString);
        ArrayList<String> matchList = new ArrayList<String>();
        while (regexMatcher.find()) {
            String groupMatch;
            if (regexMatcher.group(1) != null) {
                groupMatch = regexMatcher.group(1);
                LOGGER.debug("first group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                groupMatch = regexMatcher.group(2);
                LOGGER.debug("second group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(3) == null) continue;
            groupMatch = regexMatcher.group(3);
            LOGGER.debug("third group matched [{}]", (Object)groupMatch);
            matchList.add(groupMatch);
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String toStringSignature(Method m, Character c) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append("(");
        sb.append(Joiner.on(c.charValue()).join(Iterators.transform(Iterators.forArray(m.getParameterTypes()), GET_SIMPLE_NAME)));
        sb.append(')');
        return sb.toString();
    }
}

